<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width,initial-scale=1">
<title>GTX | NVIDIA GTX Nigeria</title>
<meta name="description" content="GTX is a Nigerian investment platform that helps users save, invest and grow wealth through accessible plans and secure transactions.">
<meta name="author" content="GTX Nigeria">
<meta name="robots" content="index,follow">
<link rel="icon" type="image/png" sizes="32x32" href="/assets/images/logo.jpg">
<link rel="icon" type="image/png" sizes="16x16" href="/assets/images/logo.jpg">
<link rel="apple-touch-icon" sizes="180x180" href="/assets/images/logo.jpg">
<meta name="theme-color" content="#008400ff">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
<link href="https://cdn.jsdelivr.net/npm/remixicon@3.5.0/fonts/remixicon.css" rel="stylesheet">

<style>
* { margin:0; padding:0; box-sizing:border-box; font-family: 'Poppins', sans-serif; }
body { min-height:100vh; background: linear-gradient(135deg, #0f2a1aff, #036320ff); color:white; overflow-x:hidden; }
.app { width:100%; max-width:520px; margin:0 auto; position:relative; }
.green-filter { filter: hue-rotate(260deg) saturate(150%); }
.container { padding:20px; padding-bottom:80px; }
.header { display:flex; align-items:center; justify-content:space-between; margin-bottom:20px; }
.user-info { display:flex; align-items:center; gap:10px; }
.avatar { width:50px; height:50px; border-radius:50%; background:white; display:flex; align-items:center; justify-content:center; color:#2563eb; font-weight:bold; }
.user-details div { font-size:13px; }
.user-details .name { font-weight:600; font-size:14px; }
.user-details .vip, .user-details .id { color:#bfdbfe; font-size:12px; }
.card { background:url('/assets/images/bgg.png'); background-size:cover; border-radius:16px; padding:16px; margin-bottom:20px; backdrop-filter:blur(8px); position:relative; }
.card-header { display:flex; align-items:center; justify-content:space-between; }
.card button { background: linear-gradient(90deg, rgba(123, 212, 72, 1), rgba(2, 109, 7, 0.6)); color:white; border:none; font-weight:800; border-radius:20px 0 0 20px; padding:10px 26px; font-size:12px; cursor:pointer; position:absolute; right:0px; top:16px; }
.apply-btn { background:#007724ff; color:white; border:none; border-radius:20px; padding:8px 16px; font-size:12px; cursor:pointer; margin-bottom:5px }
.actions { display:grid; grid-template-columns:repeat(4,1fr); gap:16px; text-align:center; margin-bottom:24px; }
.action { font-size:12px; cursor:pointer; }
.action img { margin-bottom:5px; }
.referral { background:url('/assets/images/bgg.png'); background-size:cover; border-radius:16px; padding:16px; backdrop-filter:blur(8px); margin-bottom:24px; cursor:pointer; }
.referral-header { display:flex; justify-content:space-between; align-items:center; }
.referral-stats { display:grid; grid-template-columns:repeat(3,1fr); text-align:center; margin-top:10px; font-size:13px; }
.referral-stats div { color:#e0f2fe; }
.referral-stats div span { display:block; font-weight:bold; color:white; margin-top:4px; }
.bonus { position:relative; border-radius:16px; overflow:hidden; margin-bottom:24px; }
.bonus-bg { height:140px; background-image: url('https://readdy.ai/api/search-image?query=golden%20coins%20falling'); background-size:cover; background-position:center; position:relative; }
.bonus-bg::after { content:''; position:absolute; inset:0; background:rgba(0,0,0,0.4); }
.bonus-content { position:absolute; top:0; left:0; right:0; bottom:0; padding:16px; display:flex; flex-direction:column; justify-content:center; }
.bonus-content h3 { color:#fde68a; font-weight:bold; font-size:16px; margin-bottom:4px; }
.bonus-content .amount { font-size:22px; font-weight:bold; margin-bottom:6px; }
.bonus-content p { font-size:11px; color:#f8fafc; line-height:1.4; }
.menu { margin-top:20px; }
.menu-item { display:flex; align-items:center; justify-content:space-between; padding:14px 0; border-bottom:1px solid rgba(255,255,255,0.1); cursor:pointer; }
.menu-item:last-child { border-bottom:none; }
.menu-left { display:flex; align-items:center; }
.menu-left i { font-size:20px; margin-right:10px; }
.rdm-form { background:transparent; border:none; color:#fff; font-size:14px; font-weight:700; outline:none; flex:1; caret-color:#fff; border-bottom:1px solid #fff; padding-bottom:10px; }
.rdm-form::placeholder { color:#fff; }
@media (max-width:480px) { .action img { width:42px; height:42px; } .bonus-content h3 { font-size:14px; } .bonus-content .amount { font-size:18px; } }
</style>
</head>
<body>
<div class="app">
  <main id="app-main">
    <div class="container">

      <!-- Header -->
      <div class="header">
        <div class="user-info">
          <div class="avatar">
            <img src="/assets/images/logo.jpg" alt="Logo" style="width:50px; border-radius:50%;">
          </div>
          <div class="user-details">
            <div class="name">Hello, {{ $user->name ?? 'Guest' }}!</div>
            <div class="vip">{{ $user->phone ?? '901****668' }}
              <span style="padding:3px 16px; background:linear-gradient(90deg, #f6e128, #f1fdff); position:absolute; left:180px; top:45px; border-radius:10px; color:#736200; font-weight:700;">
                VIP {{ $user->vip_level ?? 0 }}
              </span>
            </div>
            <div class="id">ID: {{ $user->id_code ?? 'N/A' }}</div>
          </div>
        </div>
      </div>

      <!-- Balance Card -->
      <div class="card">
        <div class="card-header">
          <div>
            <div class="small">Total Assets</div>
            <div style="font-size:22px; font-weight:700;">₦ {{ number_format($user->balance ?? 0,2) }}</div>
          </div>
          <button onclick="window.location.href='history'">My Bills</button>
        </div>
      </div>

      <!-- Actions -->
      <div class="actions">
        <div class="action" onclick="window.location.href='dashboard'">
          <img src="/assets/images/wallet.png" style="width:40px;" class="green-filter">
          <div>Top Up</div>
        </div>
        <div class="action" onclick="window.location.href='withdraw'">
          <img src="/assets/images/withdraw.png" style="width:40px;" class="green-filter">
          <div>Withdrawal</div>
        </div>
        <div class="action" onclick="window.location.href='card'">
          <img src="/assets/images/account.png" style="width:40px;" class="green-filter">
          <div>Account</div>
        </div>
        <div class="action" onclick="window.location.href='service'">
          <img src="/assets/images/support.png" style="width:40px;" class="green-filter">
          <div>Service</div>
        </div>
      </div>

      <!-- Referral -->
      <div class="referral" onclick="window.location.href='my-team'">
        <div class="referral-header">
          <div>
            <div style="font-weight:600; margin-bottom:6px;">Invite friends and get discounts!</div>
            <div class="referral-stats">
              <div>Team Size<span>{{ $user->team_count ?? 0 }}</span></div>
              <div>Bonus<span>₦ {{ number_format($user->referral_bonus ?? 0,2) }}</span></div>
              <div>VIP Level<span>{{ $user->vip_level ?? 0 }}</span></div>
            </div>
          </div>
          <i class="ri-arrow-right-line"></i>
        </div>
      </div>

      <!-- Bonus Pool -->
      @if(isset($bonus) && $bonus)
      <div class="bonus">
        <div class="bonus-bg"></div>
        <div class="bonus-content">
          <h3>{{ $bonus->name }}</h3>
          <div class="amount">₦ {{ number_format($bonus->amount,2) }}</div>
          <p>{{ $bonus->description }}</p>
        </div>
      </div>
      @endif

      <!-- Redeem Modal -->
      <div id="rdmContainer" style="position:fixed;display:none;inset:0;z-index:999999;background:rgba(0,0,0,0.75);">
        <div style="position:absolute;left:50%;top:50%;transform:translate(-50%,-50%);width:290px;height:230px;display:flex;align-items:center;justify-content:center;flex-direction: column">
          <img src="/assets/images/rdm.png" alt="Redeem" style="width:330px;height:330px;object-fit:cover;border-radius:6px;">
          <div style="position:absolute;bottom:-15px;left:20px;right:20px;display:flex;align-items:center;justify-content:space-between;">
            <input type="text" id="rdmCode" name="code" class="rdm-form" placeholder="Redemption code">
            <button type="button" class="apply-btn" id="rdmSubmit">Apply</button>
          </div>
          <img src="/assets/images/close.png" onclick="document.getElementById('rdmContainer').style.display='none'" style="margin-top:10px;width:38px;height:38px;cursor:pointer;" alt="Close">
        </div>
      </div>

      <!-- Success Modal -->
      <div id="rdmssContainer" style="position:fixed;display:none;inset:0;z-index:999999;background:rgba(0,0,0,0.75);">
        <div style="position:absolute;left:50%;top:50%;transform:translate(-50%,-50%);width:290px;height:280px;display:flex;align-items:center;justify-content:center;">
          <img src="/assets/images/rdmss.png" alt="Redeem Success" style="width:330px;height:330px;object-fit:cover;border-radius:6px;">
          <div style="position:absolute;bottom:35px;left:45px;right:15px;display:flex;align-items:center;justify-content:center;">
            <p id="rdmAmount" style="margin:0;color:#000;font-weight:800;font-size:22px;padding:6px 12px;border-radius:8px;">0.00</p>
          </div>
        </div>
      </div>

      <!-- Menu -->
      <div class="menu">
        <div class="menu-item" id="rdmBtn"><div class="menu-left"><i class="ri-gift-line"></i><span>Gift</span></div><i class="ri-arrow-right-line"></i></div>
        <div class="menu-item" onclick="window.location.href='https://nvidiagtx.com/sub/about'"><div class="menu-left"><i class="ri-tools-line"></i><span>Platform Rules</span></div><i class="ri-arrow-right-line"></i></div>
        <div class="menu-item" onclick="window.location.href='https://nvidiagtx.com/sub/records'"><div class="menu-left"><i class="ri-history-line"></i><span>Transaction History</span></div><i class="ri-arrow-right-line"></i></div>
        <div class="menu-item" onclick="window.location.href='https://nvidiagtx.com/sub/change-password'"><div class="menu-left"><i class="ri-lock-line"></i><span>Change Password</span></div><i class="ri-arrow-right-line"></i></div>
        <div class="menu-item" onclick="alert('Mobile app not ready');"><div class="menu-left"><i class="ri-download-line"></i><span>Download APP</span></div><i class="ri-arrow-right-line"></i></div>
      </div>
    </div>
  </main>
</div>

@include('alert-message')

<script>
document.addEventListener('DOMContentLoaded', function(){
  const rdmBtn = document.getElementById('rdmBtn');
  const rdmContainer = document.getElementById('rdmContainer');
  const rdmSubmit = document.getElementById('rdmSubmit');
  const rdmCodeInput = document.getElementById('rdmCode');
  const rdmssContainer = document.getElementById('rdmssContainer');
  const rdmAmount = document.getElementById('rdmAmount');

  rdmBtn.addEventListener('click', ()=>{ 
    rdmContainer.style.display='flex'; 
    rdmCodeInput.value=''; 
  });

  document.querySelector('#rdmContainer img[alt="Close"]').addEventListener('click', ()=>{ 
    rdmContainer.style.display='none'; 
  });

  rdmSubmit.addEventListener('click', async ()=>{
    const code = rdmCodeInput.value.trim();
    if(!code){ alert('Please enter a code'); return; }

    try{
      const res = await fetch('{{ route("user.redeem") }}', {
        method:'POST',
        headers:{
          'Content-Type':'application/json',
          'X-CSRF-TOKEN':'{{ csrf_token() }}'
        },
        body: JSON.stringify({ bonus_code: code })
      });
      const data = await res.json();

      if(data.status === 'success'){
        rdmContainer.style.display='none';
        rdmAmount.textContent='₦ '+parseFloat(data.amount).toLocaleString();
        rdmssContainer.style.display='flex';
        setTimeout(()=>{ rdmssContainer.style.display='none'; },3000);
      } else {
        alert(data.message);
      }
    } catch(err){
      alert('Server error. Try again');
      console.error(err);
    }
  });

  document.addEventListener('keydown', e=>{
    if(e.key==='Escape'){ rdmContainer.style.display='none'; rdmssContainer.style.display='none'; }
  });
});
</script>

</body>
</html>
