<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8"> 
  <meta name="viewport" content="width=device-width,initial-scale=1"> 
  <title>Register - GTX Nigeria</title> 
  <meta name="description" content="Create your GTX Nigeria account."> 
  <link rel="icon" type="image/png" href="/assets/images/logo.png">

  <link rel="preconnect" href="https://fonts.googleapis.com"> 
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin> 
  <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600;700&display=swap" rel="stylesheet"> 
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.1/css/all.min.css" crossorigin="anonymous"> 

  <style>
    :root { --bg-overlay: rgba(7,18,46,0.78); --glass: rgba(0,0,0,0.5); }
    html,body {height:100%;margin:0;font-family:'Poppins',sans-serif;background:#070b1a;color:#fff;}
    .bg {position:fixed;inset:0;background-image:url('/assets/images/684256.jpg');background-size:cover;background-position:center;z-index:0;}
    .bg::after {content:"";position:absolute;inset:0;background:linear-gradient(135deg,rgba(5,15,60,0.85) 0%,rgba(60,10,90,0.65) 50%,rgba(5,15,60,0.85) 100%);pointer-events:none;}
    .page {position:relative;z-index:1;min-height:100vh;display:flex;align-items:center;justify-content:center;padding:40px 20px;background-color:#175d003c;}
    .card {width:100%;max-width:420px;margin:0 auto;padding:28px;box-sizing:border-box;}
    h1 {margin:0 0 12px;font-size:36px;font-weight:300;}
    .lead {margin:0 0 16px;color:rgba(255,255,255,0.9);font-size:15px;}
    .input-row {display:flex;align-items:center;gap:12px;border-bottom:1px solid rgba(255,255,255,0.28);padding:12px 8px;}
    .prefix {color:#fff;font-size:16px;margin-right:4px;}
    input[type="tel"],input[type="password"],input[type="text"] {flex:1;background:transparent;border:0;color:#fff;font-size:16px;padding:10px 8px;outline:none;}
    input::placeholder {color:rgba(255,255,255,0.55);}
    .btn {width:100%;padding:12px 16px;border-radius:999px;border:0;margin-top:20px;font-size:16px;font-weight:400;cursor:pointer;transition:all .18s ease;backdrop-filter:blur(6px);background:linear-gradient(180deg,rgba(0,137,18,0.31),rgba(1,224,240,0.23));color:rgba(255,255,255,0.85);}
    .btn:disabled {opacity:0.5;cursor:not-allowed;}
    .register {margin-top:6px;text-align:center;color:rgba(255,255,255,0.8);font-size:14px;}
    .register a {color:#fff;text-decoration:underline;}
  </style>
</head>
<body>

<div class="bg"></div>

<main class="page">
  <section class="card">
    <h1>Register</h1>
    <p class="lead">Create your GTX Nigeria account</p>

    <!-- ✅ Laravel-Compatible Form -->
    <form id="register-form" method="POST" action="<?php echo e(url('register')); ?>" autocomplete="on">
      <?php echo csrf_field(); ?>

      <!-- Phone -->
      <label class="input-row" for="phone">
        <span class="prefix">+91</span>
        <input id="phone" name="phone" type="tel" pattern="[0-9]{7,15}" maxlength="15" placeholder="Phone Number" required>
      </label>

      <!-- Ref By -->
      <label class="input-row" for="ref_by">
        <input id="ref_by" name="ref_by" type="text" value="<?php echo e(isset($ref_by) && !empty($ref_by) && $ref_by != null ? $ref_by : ''); ?>" placeholder="Referral Code (optional)">
      </label>

      <!-- Password -->
      <label class="input-row" for="password">
        <input id="password" name="password" type="password" maxlength="140" placeholder="Password" required>
      </label>

      <!-- Confirm Password -->
      <label class="input-row" for="confirm_password">
        <input id="confirm_password" name="confirm_password" type="password" maxlength="140" placeholder="Confirm Password" required>
      </label>

      <button type="submit" class="btn" id="registerBtn" disabled>Create Account</button>

      <div class="register">
        Already have an account? <a href="/login">Login</a>
      </div>
    </form>
  </section>
</main>

<?php echo $__env->make('alert-message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<!-- ✅ Enable Button When Fields Filled -->
<script>
const phone = document.getElementById('phone');
const password = document.getElementById('password');
const confirmPassword = document.getElementById('confirm_password');
const registerBtn = document.getElementById('registerBtn');

function toggleButton() {
  registerBtn.disabled = !(phone.value.trim() && password.value.trim() && confirmPassword.value.trim());
}

phone.addEventListener('input', toggleButton);
password.addEventListener('input', toggleButton);
confirmPassword.addEventListener('input', toggleButton);
</script>

</body>
</html>
<?php /**PATH /home/gxkfcpnf/public_html/resources/views/app/auth/registration.blade.php ENDPATH**/ ?>