<?php $__env->startSection('admin_content'); ?>
    <section id="dashboard-ecommerce">
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-header pb-0">
                        <h4 class="card-title">
                            <div class="d-flex justify-content-between">
                                <div><?php echo e($title); ?> Payment Lists</div>
                            </div>
                        </h4>
                    </div>
                    <div class="card-content">
                        <div class="card-body card-dashboard">
                            <div class="table-responsive">
                                <table class="table table-striped dataex-html5-selectors">
                                    <thead>
                                    <tr>
                                        <th>S.N</th>
                                        <th>User</th>
                                        <th>OPTR</th>
                                        <th>TRX</th>
                                        <th>Amounts</th>
                                        <th>Photo</th>
                                        <th>Status</th>
                                        <th>Active</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php $__currentLoopData = $payments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($key + 1); ?></td>
                                            <td>
                                                
                                                <?php if($row->user): ?>
                                                    <form action="<?php echo e(route('admin.search.submit')); ?>" method="get">
                                                        <?php echo csrf_field(); ?>
                                                        <input type="hidden" id="search" name="search" class="form-control is-valid" value="<?php echo e($row->user->phone); ?>">
                                                        <input type="submit" class="btn btn-sm btn-link" value="<?php echo e($row->user->phone); ?>">
                                                    </form>
                                                <?php else: ?>
                                                    <span class="text-danger">User Deleted</span>
                                                <?php endif; ?>
                                            </td>
                                            <td><?php echo e($row->method_name); ?></td>
                                            <td><?php echo e($row->transaction_id); ?></td>
                                            <td><?php echo e(price($row->final_amount)); ?></td>
                                            <td>
                                                <a href="<?php echo e(asset($row->photo)); ?>" target="_blank">
                                                    <img src="<?php echo e(asset($row->photo)); ?>" style="width: 100px; height: 100px; object-fit: cover;" alt="Payment Proof">
                                                </a>
                                            </td>
                                            <td>
                                                <span class="badge <?php if($row->status == 'pending'): ?> badge-warning <?php elseif($row->status == 'approved'): ?> badge-success <?php elseif($row->status == 'rejected'): ?> badge-danger <?php endif; ?>" style="font-size: 10px">
                                                    <?php echo e(strtoupper($row->status)); ?>

                                                </span>
                                            </td>
                                            <td>
                                                <div class="btn-group" role="group">
                                                    <?php if($row->status == 'pending'): ?>
                                                        <a href="javascript:void(0)" data-toggle="modal" data-target="#myModal<?php echo e($row->id); ?>" class="btn btn-success btn-sm">Action</a>
                                                        
                                                        <form action="<?php echo e(route('payment.status.change', $row->id)); ?>" method="POST">
                                                            <?php echo csrf_field(); ?>
                                                            <div class="modal fade" id="myModal<?php echo e($row->id); ?>">
                                                                <div class="modal-dialog">
                                                                    <div class="modal-content">
                                                                        <div class="modal-header">
                                                                            <h4 class="modal-title">Action for Payment</h4>
                                                                            <button type="button" class="close" data-dismiss="modal">&times;</button>
                                                                        </div>
                                                                        <div class="modal-body">
                                                                            <div class="form-group">
                                                                                <label for="status">Status <small class="text-info">Approved adds balance to user.</small></label>
                                                                                <select name="status" required class="form-control">
                                                                                    <option value="approved">Approved</option>
                                                                                    <option value="rejected">Rejected</option>
                                                                                    <option value="pending">Pending</option>
                                                                                </select>
                                                                            </div>
                                                                        </div>
                                                                        <div class="modal-footer">
                                                                            <button type="submit" class="btn btn-primary">Submit</button>
                                                                            <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </form>
                                                    <?php else: ?>
                                                        <span class="text-muted small">Processed</span>
                                                    <?php endif; ?>

                                                    
                                                    <a href="<?php echo e(route('admin.customer.login', $row->id)); ?>" 
                                                       target="_blank" 
                                                       class="btn btn-info btn-sm ml-1" 
                                                       data-toggle="tooltip" 
                                                       title='Login Into User Account'>
                                                        <i class="bx bx-user"></i>
                                                    </a>
                                                </div>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.partials.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/gxkfcpnf/public_html/resources/views/admin/pages/payment/list.blade.php ENDPATH**/ ?>