<html lang="en">
 <head> 
  <meta charset="utf-8"> 
  <meta name="viewport" content="width=device-width,initial-scale=1"> 
  <title>GTX | Weekly Salary</title> 
  <link rel="icon" type="image/png" sizes="32x32" href="/assets/images/logo.jpg"> 
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css"> 
  <link href="https://cdn.jsdelivr.net/npm/remixicon@3.5.0/fonts/remixicon.css" rel="stylesheet"> 
  <style>
    * { margin: 0; padding: 0; box-sizing: border-box; font-family: 'Poppins', sans-serif; }
    body { min-height: 100vh; background: linear-gradient(135deg, #0f2a1aff, #036320ff); color: white; overflow-x: hidden; }
    .app { width:100%; max-width:520px; margin:0 auto; position:relative; }
    .vip-card { background: url('/assets/images/slr.png'); background-size: cover; border-radius: 10px; padding: 1rem; margin: 0.75rem; color: #1f2937; margin-top: 80px }
    .levels { padding: 0 0.75rem 2rem; display: flex; flex-direction: column; gap: 0.75rem; margin-bottom: 50px }
    .level-card { background: white; border-radius: 10px; padding: 0.75rem; color: #1f2937; }
    .level-top { display: flex; justify-content: space-between; align-items: flex-start; margin-bottom: 0.5rem; }
    .level-top p { font-size: 0.75rem; color: #374151; line-height: 1.3; flex: 1; margin-right: 0.5rem; }
    .level-badge { position: relative; width: 3rem; height: 3rem; border-radius: 50%; background: linear-gradient(to bottom right, #facc15, #fb923c); display: flex; align-items: center; justify-content: center; }
    .level-badge-inner { width: 2.3rem; height: 2.3rem; border-radius: 50%; background: linear-gradient(to bottom right, #fde047, #fb923c); display: flex; align-items: center; justify-content: center; color: white; font-weight: 700; font-size: 0.65rem; }
    .intel { position: absolute; bottom: -5px; left: 50%; transform: translateX(-50%); background: #ef4444; color: white; font-size: 0.55rem; padding: 1px 5px; border-radius: 999px; font-weight: 500; }
    .level-bottom { display: flex; justify-content: space-between; align-items: center; }
    .level-bottom span { font-size: 0.75rem; color: #4b5563; }
    .header { position: fixed; top: 0; left: 0; right: 0; background: linear-gradient(to right, #0f2a12ff, #258a1eff); display: flex; justify-content: space-between; align-items: center; padding: 16px; z-index: 50; }
    .header h1 { font-size: 18px; font-weight: 500; color: white; }
    .topup { color: #68fa60ff; font-size: 14px; font-weight: 500; background: none; border: none; cursor: pointer; }
  </style> 
 </head> 
 <body> 
  <div class="app"> 
   <main id="app-main"> 
    <div class="header"> 
     <button onclick="window.history.back()" style="background:none; border:none; color:white;"><i class="ri-arrow-left-line"></i></button> 
     <h1>Weekly Salary</h1> 
     <button class="topup" onclick="window.location.href='/my-team'">My Team</button> 
    </div> 

    <div class="vip-card"> 
     <div class="content"> 
      <div> 
       <p>Available Member Balance</p> 
       <h2>Current VIP <?php echo e(auth()->user()->vip_level ?? 0); ?></h2> 
       <p>New Direct Referrals (Wallet Points)</p> 
       <h3><?php echo e($newReferralsCount ?? 0); ?> Members</h3> 
       <p style="font-size: 10px; color: #555;">Spent points are deducted on claim</p>
      </div> 
     </div> 
    </div> 

    <div class="levels">
        <?php
            $weeklyTasks = [
                ['id' => 1, 'invites' => 3, 'bonus' => 100],
                ['id' => 2, 'invites' => 6, 'bonus' => 200],
                ['id' => 3, 'invites' => 10, 'bonus' => 400],
                ['id' => 4, 'invites' => 15, 'bonus' => 600],
                ['id' => 5, 'invites' => 30, 'bonus' => 1600],
                ['id' => 6, 'invites' => 45, 'bonus' => 2500],
            ];
        ?>

        <?php $__currentLoopData = $weeklyTasks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $task): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php
                // Check if this specific task ID has been claimed this week
                $isDone = in_array($task['id'], $claimedTaskIds ?? []);
                
                // User can claim if balance is enough and task is not already done
                $canClaim = (($newReferralsCount ?? 0) >= $task['invites'] && !$isDone);
            ?>
            <div class="level-card"> 
                <div class="level-top"> 
                    <p>Requires <b><?php echo e($task['invites']); ?></b> member points. Once claimed, these points will be deducted from your pool.</p> 
                    <div class="level-badge"> 
                        <div class="level-badge-inner">Rs <?php echo e($task['bonus']); ?></div> 
                        <div class="intel">WEEKLY</div> 
                    </div> 
                </div> 
                <div class="level-bottom">
                    <span>Target: <?php echo e($task['invites']); ?> Members</span>
                    <form method="POST" action="<?php echo e(url('/grade/claim/'.$task['id'])); ?>">
                        <?php echo csrf_field(); ?>
                        <button type="submit" <?php echo e(!$canClaim ? 'disabled' : ''); ?>

                            style="background: <?php echo e($isDone ? '#258a1eff' : ($canClaim ? '#68fa60ff' : '#e5e7eb')); ?>;
                                   color: <?php echo e(($canClaim || $isDone) ? '#1f2937' : '#6b7280'); ?>; border:none; padding: 6px 15px; border-radius: 20px; font-weight: bold; cursor: pointer;">
                            <?php echo e($isDone ? 'Received ✓' : ($canClaim ? 'Claim Reward' : 'Low Points')); ?>

                        </button>
                    </form>
                </div> 
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        <div style="width:100%;margin:18px auto;padding:18px;border-radius:14px;background:white;color:#1f2937;box-shadow:0 10px 30px rgba(0,0,0,0.1);"> 
            <div style="text-align: center; margin-bottom: 15px;">
                <h2 style="font-size: 16px; color: #0b84ff;">Regional Manager (Weekly)</h2>
                <p style="font-size: 12px; color: #6b7280;">Reach VIP 7 Milestone</p>
            </div>
            <div style="background: #fff1f0; padding: 15px; border-radius: 10px; text-align: center;">
                <div style="font-size: 22px; font-weight: 800; color: #b91c1c;">Rs 1,500,000</div>
            </div>
        </div>
    </div> 
   </main>
  </div> 
 </body>
</html>
<?php /**PATH /home/gxkfcpnf/public_html/resources/views/app/main/salary/index.blade.php ENDPATH**/ ?>