<script>
    document.addEventListener('DOMContentLoaded', function () {
        // Select all delete buttons with class starting with 'delete_confirm'
        document.querySelectorAll("[class^='delete_confirm']").forEach(function(button) {
            button.addEventListener('click', function(e) {
                e.preventDefault(); // Prevent default form submission
                
                // Find the closest form
                var form = button.closest('form');

                // Show SweetAlert confirmation
                Swal.fire({
                    title: 'Are you sure?',
                    text: "If you delete this, it will be gone forever.",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#3085d6',
                    cancelButtonColor: '#d33',
                    confirmButtonText: 'Yes, delete it!'
                }).then((result) => {
                    if (result.isConfirmed) {
                        form.submit(); // Submit the form
                        Swal.fire(
                            'Deleted!',
                            'Your item has been deleted.',
                            'success'
                        );
                    }
                });
            });
        });
    });
</script>
<?php /**PATH /home/gxkfcpnf/public_html/resources/views/admin/partials/delete-confirmation.blade.php ENDPATH**/ ?>