<?php
  $user = auth()->user();
  $methods = \App\Models\PaymentMethod::get();
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width,initial-scale=1" />
  <title>GTX | Top Up</title>
  <link rel="icon" href="/assets/images/logo.jpg" />
  <link href="https://cdn.jsdelivr.net/npm/remixicon@3.5.0/fonts/remixicon.css" rel="stylesheet" />
  <style>
    * { margin: 0; padding: 0; box-sizing: border-box; font-family: 'Poppins', sans-serif; }
    body { min-height: 100vh; background: linear-gradient(135deg, #0f2a1aff, #036320ff); color: white; overflow-x: hidden; }
    .app { width:100%; max-width:520px; margin:0 auto; position:relative; }
    .green-filter { filter: hue-rotate(260deg) saturate(150%); }
    .header{display:flex;justify-content:space-between;align-items:center;padding:2rem 1rem 1rem}
    .header button{background:none;border:none;color:#fff;font-size:1.4rem;cursor:pointer}
    .apd-balance{padding:0 16px 24px;position:relative}
    .apd-balance img{position:absolute;top:0;right:16px;width:100px;object-fit:cover}
    .apd-balance .label{color:rgba(255,255,255,.7);font-size:14px;margin-bottom:4px}
    .apd-balance .value{font-size:28px;font-weight:700}
    
    .amount-section, .channel-section{padding:0 16px 16px}
    
    /* Amount Input Box */
    .amount-input{background:#fff;border-radius:5px;display:flex;align-items:center;padding:12px 14px;margin-top:10px}
    .amount-input span{color:#555;font-size:20px;margin-right:8px;font-weight:bold}
    .amount-input input{border:none;outline:none;background:transparent;color:#00741d;font-size:22px;font-weight:700;width:100%}
    
    .methods{display:flex;flex-direction:column;gap:10px;margin-top:12px}
    .method-card{background:#fff;color:#000;display:flex;align-items:center;justify-content:space-between;border-radius:10px;padding:10px 14px;cursor:pointer;transition:.3s; border: 2px solid transparent;}
    .method-card.active{border:2px solid #33ff6b;box-shadow:0 0 8px rgba(0,255,0,.4)}
    .method-left{display:flex;align-items:center;gap:10px}
    .method-icon{width:36px;height:36px;border-radius:50%;display:flex;align-items:center;justify-content:center;background:#0b4a22;color:#fff;font-size:18px}
    .continue-btn{background:linear-gradient(to right,#25eb67,#1eaf2c);color:#fff;border:none;width:calc(100% - 32px);margin:16px;padding:16px;border-radius:14px;font-size:18px;font-weight:500;cursor:pointer}
    
    .reminder-box { margin: 16px; padding: 20px; background: rgba(0, 0, 0, 0.25); border-radius: 16px; border: 1px solid rgba(255, 255, 255, 0.1); }
    .reminder-item { display: flex; gap: 12px; margin-bottom: 15px; align-items: flex-start; }
    .reminder-item i { font-size: 20px; margin-top: 2px; }
    .reminder-item p { font-size: 13px; line-height: 1.5; color: rgba(255, 255, 255, 0.9); }
  </style>
</head>
<body>
<div class="app">
  <div class="header">
    <button onclick="history.back()"><i class="ri-arrow-left-line"></i></button>
    <h1 style="font-size:1.1rem;font-weight:500;">Top Up</h1>
    <button onclick="window.location.href='<?php echo e(route('recharge.history.preview')); ?>'"><i class="ri-history-line"></i></button>
  </div>

  <div class="apd-balance">
    <img src="<?php echo e(asset('assets/images/dep.png')); ?>" class="green-filter">
    <p class="label">Balance</p>
    <p class="value"><?php echo e(price($user->balance)); ?></p>
  </div>

  <form id="paymentForm" method="POST">
    <?php echo csrf_field(); ?>
    <input type="hidden" name="user" value="<?php echo e(auth()->user()->phone); ?>">
    <input type="hidden" name="amount" id="finalAmount">
  </form>

  <div class="amount-section">
    <h3 style="font-size: 16px;">Top up amount</h3>
    <div class="amount-input">
      <span><?php echo e(setting('currency')); ?></span>
      <input type="number" id="manual_amount" placeholder="Enter amount">
    </div>
  </div>

  <div class="channel-section">
    <h3 style="font-size: 16px;">Top up channel</h3>
    <div class="methods" id="methodList">
      <div class="method-card active" onclick="selectMethod('wppay', this)">
        <div class="method-left"><div class="method-icon"><i class="ri-bank-card-line"></i></div>
        <div><p style="font-weight:600">WPpay-1</p><small style="color:#666">Instant Pay</small></div></div>
        <i class="ri-arrow-right-s-line" style="color:#666"></i>
      </div>
      <div class="method-card" onclick="selectMethod('wppay', this)">
        <div class="method-left"><div class="method-icon"><i class="ri-bank-card-line"></i></div>
        <div><p style="font-weight:600">WPpay-2</p><small style="color:#666">Fast Channel</small></div></div>
        <i class="ri-arrow-right-s-line" style="color:#666"></i>
      </div>
      <div class="method-card" onclick="selectMethod('wppay', this)">
        <div class="method-left"><div class="method-icon"><i class="ri-bank-card-line"></i></div>
        <div><p style="font-weight:600">WPpay-3</p><small style="color:#666">Secure Pay</small></div></div>
        <i class="ri-arrow-right-s-line" style="color:#666"></i>
      </div>
      <div class="method-card" onclick="selectMethod('wppay', this)">
        <div class="method-left"><div class="method-icon"><i class="ri-bank-card-line"></i></div>
        <div><p style="font-weight:600">WPpay-4</p><small style="color:#666">Direct Deposit</small></div></div>
        <i class="ri-arrow-right-s-line" style="color:#666"></i>
      </div>
    </div>
  </div>

  <button type="button" class="continue-btn" onclick="goPayment()">Continue</button>

  <div class="reminder-box">
    <p style="font-size: 16px; font-weight: 600; margin-bottom: 18px; color: #5aff48;">Top up reminder</p>
    <div class="reminder-item">
        <i class="ri-error-warning-fill" style="color: #ff4d4d;"></i>
        <p><strong>Do not save (UPI account)</strong> to make multiple payments. Please click to copy the latest (UPI account) for each payment.</p>
    </div>
    <div class="reminder-item">
        <i class="ri-checkbox-circle-fill" style="color: #5aff48;"></i>
        <p>Payment is successful, please <strong>fill in the 12-digit UTR</strong> reference number to complete recharge.</p>
    </div>
    <div class="reminder-item">
        <i class="ri-customer-service-2-fill" style="color: #4da3ff;"></i>
        <p>If you encounter problems during the recharge process, please consult your <strong>dedicated wealth manager</strong>.</p>
    </div>
  </div>
</div>

<script>
let selectedMethod = 'wppay';

function selectMethod(methodName, element){
  document.querySelectorAll('.method-card').forEach(el => el.classList.remove('active'));
  element.classList.add('active');
  selectedMethod = methodName;
}

function goPayment(){
  const amt = document.getElementById('manual_amount').value;
  if(!amt || amt < 500){
    alert('Please enter a valid amount');
    return;
  }
  document.getElementById('finalAmount').value = amt;
  const form = document.getElementById('paymentForm');
  form.action = '/services/deposit.php'; 
  form.submit();
}
</script>
</body>
</html>
<?php /**PATH /home/gxkfcpnf/public_html/resources/views/app/main/recharge/index.blade.php ENDPATH**/ ?>