<?php $__env->startSection('admin_content'); ?>
    <section id="dashboard-ecommerce">
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-header pb-0">
                        <h4 class="card-title">
                            <div class="d-flex justify-content-between">
                                <div><?php echo e($title); ?> Withdraw Lists</div>
                            </div>
                        </h4>
                    </div>
                    <div class="card-content">
                        <div class="card-body card-dashboard">
                            <div class="table-responsive">
                                <table class="table table-striped dataex-html5-selectors">
                                    <thead>
                                    <tr>
                                        <th>S.N</th>
                                        <th>User Info</th>
                                        <th>Channel</th>
                                        <th>Bank Details</th> <th>Amount</th>
                                        <th>Status</th>
                                        <th>Action</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php $__currentLoopData = $withdraws; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($key + 1); ?></td>
                                            <td>
                                                <small>
                                                    <strong>Phone:</strong> <?php echo e($row->user->phone ?? '--'); ?>  <br>
                                                    <strong>Ref ID:</strong> <?php echo e($row->user->ref_id ?? '--'); ?> <br>
                                                </small>
                                            </td>
                                            <td>
                                                <?php echo e($row->payment_method); ?>

                                            </td>
                                            <td style="min-width: 180px;">
                                                <small>
                                                    <strong>Holder:</strong> <?php echo e($row->user->realname ?? '--'); ?> <br>
                                                    <strong>Bank:</strong> <?php echo e($row->user->bank_name ?? '--'); ?> <br>
                                                    <strong>A/C:</strong> <?php echo e($row->number ?? '---'); ?> 
                                                    <a href="javascript:void(0)" onclick="copyLink('<?php echo e($row->number); ?>')" class="btn btn-sm btn-primary" style="padding: 0px 4px; font-size: 10px;">Copy</a> <br>
                                                    <strong>IFSC:</strong> <?php echo e($row->user->ifsc ?? '--'); ?>

                                                </small>
                                            </td>
                                            <td>
                                                <small>
                                                    Withdraw: <?php echo e(price($row->amount)); ?> <br>
                                                    Charge: <?php echo e(price($row->charge)); ?> <br>
                                                    <strong>Final: <?php echo e(price($row->final_amount)); ?></strong>
                                                </small>
                                            </td>
                                            <td>
                                                <span class="badge <?php if($row->status == 'pending'): ?> badge-warning <?php elseif($row->status == 'approved'): ?> badge-success  <?php elseif($row->status == 'rejected'): ?> badge-danger <?php endif; ?>" style="font-size: 10px"><?php echo e(ucfirst($row->status)); ?></span>
                                            </td>
                                            <td>
                                                <?php if($row->status == 'pending'): ?>
                                                    <a href="javascript:void(0)" data-toggle="modal" data-target="#myModal<?php echo e($row->id); ?>" class="btn btn-success btn-sm">Action</a>
                                                    <form action="<?php echo e(route('withdraw.status.change', $row->id)); ?>" method="POST"><?php echo csrf_field(); ?>
                                                        <div class="modal fade" id="myModal<?php echo e($row->id); ?>">
                                                            <div class="modal-dialog">
                                                                <div class="modal-content">

                                                                    <div class="modal-header">
                                                                        <h4 class="modal-title">Process Withdrawal</h4>
                                                                        <button type="button" class="close" data-dismiss="modal">&times;</button>
                                                                    </div>

                                                                    <div class="modal-body text-left">
                                                                        <div class="form-group">
                                                                            <label for="status">Change Status</label>
                                                                            <select name="status" required id="status" class="form-control">
                                                                                <option value="approved">Approve</option>
                                                                                <option value="rejected">Reject</option>
                                                                                <option value="pending">Keep Pending</option>
                                                                            </select>
                                                                        </div>
                                                                    </div>

                                                                    <div class="modal-footer">
                                                                        <button type="submit" class="btn btn-primary">Submit</button>
                                                                        <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
                                                                    </div>

                                                                </div>
                                                            </div>
                                                        </div>
                                                    </form>
                                                <?php else: ?>
                                                    <div class="badge badge-light-secondary">Processed</div>
                                                <?php endif; ?>

                                                <a href="<?php echo e(route('admin.customer.login', $row->user->id)); ?>"
                                                   target="_blank"
                                                   class="btn btn-info btn-sm"
                                                   data-toggle="tooltip" title='Login Into User Account'>
                                                    <i class="bx bx-user"></i></a>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php echo $__env->make('alert-message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <script>
        function copyLink(text)
        {
            const body = document.body;
            const input = document.createElement("input");
            body.append(input);
            input.style.opacity = 0;
            input.value = text.replaceAll(' ', '');
            input.select();
            input.setSelectionRange(0, input.value.length);
            document.execCommand("Copy");
            input.blur();
            input.remove();
            message('Copied to clipboard!')
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.partials.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/gxkfcpnf/public_html/resources/views/admin/pages/withdraw/list.blade.php ENDPATH**/ ?>