<?php
include_once('./db.php'); 

$data = file_get_contents("php://input");
$ret = json_decode($data, true);

$logFile = __DIR__ . '/wcallback_logs.txt';
file_put_contents($logFile, date('Y-m-d H:i:s') . " - " . $data . PHP_EOL, FILE_APPEND | LOCK_EX);

if (!isset($ret['merOrderNo']) || !isset($ret['status'])) {
    echo "INVALID_DATA";
    exit;
}

$merOrderNo = $ret['merOrderNo'];
$status = (int)$ret['status'];

$stmt = $conn->prepare("SELECT * FROM withdrawals WHERE oid = ? AND status = 'processing'");
$stmt->bind_param("s", $merOrderNo);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $user_id = $row['user_id'];
        $amount  = $row['amount'];

        if ($status === 7) {

            $update = $conn->prepare("
                UPDATE withdrawals 
                SET status = 'approved', updated_at = NOW()
                WHERE oid = ? AND status = 'processing'
            ");
            $update->bind_param("s", $merOrderNo);
            $update->execute();

            echo "SUCCESS";

        } elseif (in_array($status, [2, 6, 8])) {

            $conn->begin_transaction();

            try {

                $update = $conn->prepare("
                    UPDATE withdrawals 
                    SET status = 'rejected', admin_feedback = 'Payment failed by provider', updated_at = NOW()
                    WHERE oid = ? AND status = 'processing'
                ");
                $update->bind_param("s", $merOrderNo);
                $update->execute();

                $refund = $conn->prepare("
                    UPDATE users 
                    SET balance = balance + ? 
                    WHERE id = ?
                ");
                $refund->bind_param("di", $amount, $user_id);
                $refund->execute();

                $conn->commit();
                echo "REFUNDED";

            } catch (Exception $e) {
                $conn->rollback();
                echo "ERROR_REFUND";
            }

        } else {
            echo "IGNORED";
        }
    }
} else {
    echo "ORDER_NOT_FOUND"; 
}
?>
