<?php
include_once('./db.php'); 
include_once('./function.php'); 

function generateRandomEmail() {
    $domains = ['gmail.com', 'yahoo.com', 'outlook.com', 'hotmail.com'];
    $name = substr(str_shuffle('abcdefghijklmnopqrstuvwxyz0123456789'), 0, 8);
    return $name . '@' . $domains[array_rand($domains)];
}

$username = isset($_POST['user']) ? trim($_POST['user']) : null;
$amount   = isset($_POST['amount']) ? trim($_POST['amount']) : null;

if ($username === '' || $amount === '' || !is_numeric($amount) || $amount <= 0) {
    die(json_encode(['status' => 0, 'message' => 'Invalid amount or username']));
}

$trade_amount = number_format((float)$amount, 2, '.', '');

date_default_timezone_set('Asia/Kolkata');
$order_date = date("d-m-Y H:i:s");
$created_at = date("Y-m-d H:i:s");

try {

    $stmt = $conn->prepare("SELECT id FROM users WHERE phone = ?");
    $stmt->bind_param("s", $username);
    $stmt->execute();
    $result = $stmt->get_result();
    $user = $result->fetch_assoc();
    $stmt->close();

    if (!$user) {
        die(json_encode(['status' => 0, 'message' => 'User not found']));
    }

    $user_id = $user['id'];

    $order_id = 'GBPAY' . strtoupper(bin2hex(random_bytes(6)));
    $transaction_id = $order_id;


    $data = [];
    $data['merNo']       = $mch_id;
    $data['merOrderNo']  = $order_id;
    $data['name']        = $username;
    $data['email']       = generateRandomEmail();
    $data['phone']       = $username;
    $data['orderAmount'] = $trade_amount;
    $data['currency']    = "INR";
    $data['busiCode']    = "103001";
    $data['notifyUrl']   = 'https://loreal-paris.online/services/gbpay/callback.php';
    $data['timestamp']   = msectime();
    $data['sign']        = makeSign($data);

    $data_json = json_encode($data, JSON_UNESCAPED_UNICODE);
    $url = 'https://naskl.gctpk.com/payin/createOrder';
    $ret = globalpay_http_post_res_json($url, $data_json);
    $response = json_decode($ret, true);

    $pay_link = $response['data']['orderData'] ?? null;


    $stmt = $conn->prepare("
        INSERT INTO deposits 
        (user_id, method_name, order_id, transaction_id, charge_amount, amount, final_amount, pay_link, data, date, status, created_at)
        VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
    ");

    $method_name   = 'Globalpay';
    $charge_amount = 0.00;
    $status        = 'pending';

    $json_data = json_encode([
        'reference' => $order_id
    ]);

    $stmt->bind_param(
        "isssdsdsssss",
        $user_id,
        $method_name,
        $order_id,
        $transaction_id,
        $charge_amount,
        $trade_amount,
        $trade_amount,
        $pay_link,
        $json_data,
        $order_date,
        $status,
        $created_at
    );

    $stmt->execute();
    $stmt->close();


    if (!empty($pay_link)) {
        header("Location: " . $pay_link);
        exit;
    } else {
        header("Location: ./maintenance.php");
        exit;
    }

} catch (Exception $e) {
    header("Location: ./maintenance.php");
    exit;
}
?>
