{{-- resources/views/withdraw-preview.blade.php --}}
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>GTX | Withdraw History</title>
<link rel="icon" href="{{ asset('assets/images/logo.jpg') }}">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
<link href="https://cdn.jsdelivr.net/npm/remixicon@3.5.0/fonts/remixicon.css" rel="stylesheet">
<style>
    * { margin: 0; padding: 0; box-sizing: border-box; font-family: 'Poppins', sans-serif; }
    body { min-height: 100vh; background: linear-gradient(135deg, #0f2a1aff, #036320ff); color: white; overflow-x: hidden; }
    .app { width:100%; max-width:520px; margin:0 auto; position:relative; }
    .header { display:flex; justify-content:space-between; align-items:center; padding:3rem 1rem 1rem; }
    .header button { background:none; border:none; color:#fff; cursor:pointer; font-size:1.5rem; }
    .transactions { padding:0 10px 10px; }
    .transaction { border-radius:16px; padding:15px; margin-bottom:12px; background:rgba(255,255,255,0.08); border: 1px solid rgba(255,255,255,0.05); }
    .transaction .top { display:flex; justify-content:space-between; align-items:center; }
    .left { display:flex; align-items:center; gap:12px; }
    .icon-bg { width:40px; height:40px; background:rgba(90, 255, 72, 0.2); border-radius:50%; display:flex; align-items:center; justify-content:center; }
    .icon-bg i { color: #5aff48; font-size: 20px; }
    .details h3 { font-size:14px; font-weight:500; margin:0; }
    .details p { font-size:11px; color:rgba(255,255,255,0.6); margin-top:2px; }
    .amount { font-size:15px; font-weight:700; color: #fff; }
    .empty { text-align:center; color:rgba(255,255,255,0.6); margin-top:100px; }
    .empty i { font-size: 50px; margin-bottom: 10px; display: block; }
</style>
</head>
<body>
<div class="app">
    <div class="header">
        <button onclick="window.history.back()"><i class="ri-arrow-left-line"></i></button>
        <h1 style="font-size:1.1rem; font-weight:500;">Withdraw History</h1>
        <div style="width:2rem;"></div>
    </div>

    <main class="transactions">
        @if($withdrawals->count() > 0)
            @foreach($withdrawals as $wd)
                <div class="transaction">
                    <div class="top">
                        <div class="left">
                            <div class="icon-bg"><i class="ri-bank-card-line"></i></div>
                            <div class="details">
                                <h3>Withdrawal 
                                    @if($wd->status == 'pending')
                                        <span style="color:#ffcc00"> (Pending)</span>
                                    @elseif($wd->status == 'approved')
                                        <span style="color:#00ff3c"> (Success)</span>
                                    @else
                                        <span style="color:#ff4d4d"> (Failed)</span>
                                    @endif
                                </h3>
                                <p>{{ $wd->created_at->format('d M Y, h:i A') }}</p>
                            </div>
                        </div>
                        <div class="right" style="text-align: right;">
                            <div class="amount">- Rs {{ number_format($wd->amount, 2) }}</div>
                            <p style="font-size: 10px; color: rgba(255,255,255,0.5)">Final: Rs {{ number_format($wd->final_amount, 2) }}</p>
                        </div>
                    </div>
                </div>
            @endforeach
        @else
            <div class="empty">
                <i class="ri-file-list-3-line"></i>
                <p>No History Found</p>
            </div>
        @endif
    </main>
</div>
</body>
</html>
