<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width,initial-scale=1.0">
<title>GTX | Withdraw</title>
<meta name="csrf-token" content="{{ csrf_token() }}">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
<link href="https://cdn.jsdelivr.net/npm/remixicon@3.5.0/fonts/remixicon.css" rel="stylesheet">

<style>
/* Base styling */
*{margin:0;padding:0;box-sizing:border-box;font-family:Poppins,sans-serif;}
body{min-height:100vh;background:linear-gradient(135deg,#0f2a1aff,#036320ff);color:#fff;overflow-x:hidden;}
.app{width:100%;max-width:520px;margin:0 auto;position:relative;padding-bottom:50px;}
.header{display:flex;justify-content:space-between;align-items:center;padding:1.5rem 1rem;}
.header button{background:none;border:none;color:#fff;font-size:1.5rem;cursor:pointer;}

/* Bank Card Styling */
.green-filter { filter: hue-rotate(260deg) saturate(150%); }
.apd-balance { padding: 20px; margin: 0 16px 20px; background: rgba(255, 255, 255, 0.08); border-radius: 15px; position: relative; overflow: hidden; border: 1px solid rgba(255,255,255,0.1); }
.apd-balance img { position: absolute; top: -10px; right: -10px; width: 100px; opacity: 0.5; }
.apd-balance .label { color: rgba(255,255,255,0.6); font-size: 13px; margin-bottom: 5px; }
.apd-balance .value { font-size: 18px; font-weight: 700; color: #fff; margin-bottom: 10px; display: block; }
.sub-values .row { font-size: 14px; color: rgba(255,255,255,0.8); margin-bottom: 3px; display: flex; align-items: center; gap: 8px; }

/* Amount Section */
.amount-section{padding:0 16px 16px;}
.amount-section h3{font-size:16px;margin-bottom:12px; font-weight: 500;}
.amount-input{display:flex;align-items:center;background:#fff;border-radius:8px;padding:12px 16px;color:#00741dff;}
.amount-input span { font-size: 22px; font-weight: 700; margin-right: 10px; color: #00741d; }
.amount-input input{border:none;background:transparent;outline:none;font-size:22px;font-weight: 700; color:#00741dff;width:100%;}
#feeInfo { margin-top: 10px; font-size: 14px; color: rgba(255,255,255,0.9); }

/* Channel Section */
.channel-section{padding:0 16px;margin-top:16px;}
.channel-card{display:flex;align-items:center;padding:12px;background:#fff;border-radius:8px;margin-bottom:12px;cursor:pointer;border: 1px solid rgba(255,255,255,0.1);}
.channel-card .icon{width:40px;height:40px;border-radius:20px;display:flex;align-items:center;justify-content:center;color:#fff;margin-right:16px; font-size: 20px;}
.channel-card .info span{font-weight:700;color:#222; font-size: 16px;}

/* Button */
.continue-btn{width:calc(100% - 32px);margin:20px 16px;padding:16px;background:linear-gradient(to right,#25eb67ff,#1eaf2cff);border:none;border-radius:12px;color:#fff;font-size:18px;font-weight:600;cursor:pointer;transition: 0.3s;}
.continue-btn.disabled{opacity:0.5;cursor:not-allowed; filter: grayscale(1);}

/* Guidelines Section */
.guidelines-box { margin: 16px; padding: 20px; background: rgba(0, 0, 0, 0.2); border-radius: 15px; border: 1px solid rgba(255,255,255,0.05); }
.guidelines-box h3 { font-size: 18px; margin-bottom: 15px; color: #5aff48; font-weight: 600; }
.guide-item { font-size: 13px; color: rgba(255,255,255,0.8); margin-bottom: 10px; line-height: 1.5; display: flex; gap: 10px; }
.guide-item i { color: #5aff48; font-size: 16px; margin-top: 2px; }
</style>
</head>
<body>

<div class="app">
    <div class="header">
        <button onclick="window.history.back();"><i class="ri-arrow-left-line"></i></button>
        <h2 style="font-size: 1.2rem; font-weight: 500;">Withdraw</h2>
        <button onclick="window.location.href='{{ url('withdraw-preview') }}'"><i class="ri-history-line"></i></button>
    </div>

    <div class="apd-balance">
        <img src="/assets/images/dep.png" alt="" class="green-filter">
        <p class="label">Bank Account Details</p>
        <p class="value">{{ old('name', auth()->user()->name ?? 'User Name') }}</p>
        <div class="sub-values">
            <div class="row"><i class="ri-bank-line"></i> <span>{{ old('name', auth()->user()->gateway_name ?? 'Bank Name') }}</span></div>
            <div class="row"><i class="ri-number-8"></i> <span>{{ old('name', auth()->user()->bank ?? '******') }}</span></div>
        </div>
    </div>

    <div class="amount-section">
        <h3>Withdraw Amount</h3>
        <div class="amount-input">
            <span id="currencySymbol">Rs</span>
            <input type="number" id="withdrawAmount" placeholder="Enter amount" oninput="updateAmount()" min="0">
        </div>
        <div id="feeInfo">
            Tax: <strong>6%</strong> | Receive: <strong id="receiveVal">Rs 0.00</strong>
        </div>
    </div>

    <div class="channel-section">
        <h3>Withdrawal Channel</h3>
        <div class="channel-card active">
            <div class="icon" style="background:linear-gradient(to bottom right,#34d399,#059669)"><i class="ri-bank-line"></i></div>
            <div class="info"><span>Bank Transfer</span></div>
        </div>
    </div>

    <form action="{{ route('user.withdraw-confirm-submit') }}" method="POST" id="withdrawForm">
        @csrf
        <input type="hidden" name="type" value="bank">
        <input type="hidden" name="amount" id="formAmount" value="">
        <input type="hidden" name="channel" value="bank">
        <button type="submit" class="continue-btn disabled" id="submitBtn" disabled>Withdraw</button>
    </form>

    <div class="guidelines-box">
        <h3>Withdrawal Guidelines</h3>
        <div class="guide-item">
            <i class="ri-checkbox-circle-fill"></i>
            <p>Minimum withdrawal amount is <strong>Rs 110</strong> and maximum withdrawal amount is <strong>Rs 50,000</strong>.</p>
        </div>
        <div class="guide-item">
            <i class="ri-error-warning-fill"></i>
            <p>Please ensure your bank account details are correct before submitting. Incorrect details may cause delay or rejection.</p>
        </div>
        <div class="guide-item">
            <i class="ri-time-fill"></i>
            <p>Withdrawal processing time is <strong>24 to 72 working hours</strong>.</p>
        </div>
        <div class="guide-item">
            <i class="ri-calendar-event-fill"></i>
            <p>You can place only <strong>one withdrawal request per day</strong>.</p>
        </div>
    </div>
</div>

<script>
function updateAmount(){
    const amountInput = document.getElementById('withdrawAmount');
    const submitBtn = document.getElementById('submitBtn');
    const receiveVal = document.getElementById('receiveVal');
    const formAmount = document.getElementById('formAmount');
    
    let amount = parseFloat(amountInput.value) || 0;
    
    // Minimum 110 check for button enable
    if(amount >= 110){
        submitBtn.classList.remove('disabled');
        submitBtn.disabled = false;
    } else {
        submitBtn.classList.add('disabled');
        submitBtn.disabled = true;
    }

    // Calculate 6% Tax
    const taxRate = 0.06; 
    const tax = amount * taxRate;
    const receive = amount - tax;

    receiveVal.innerHTML = `Rs ${receive.toFixed(2)}`;
    formAmount.value = amount;
}
</script>

</body>
</html>
