@php
use App\Models\Purchase;
use Carbon\Carbon;
$purchases = Purchase::where('user_id', auth()->id())->orderByDesc('id')->get();
$active = $purchases->where('status','active');
$completed = $purchases->where('status','inactive');
$totalReceivable = $active->sum('receive_able_amount');
@endphp

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width,initial-scale=1">
<title>GTX | My Devices</title>
<link rel="icon" href="/assets/images/logo.jpg">
<meta name="csrf-token" content="{{ csrf_token() }}">
 <meta name="description" content="GTX is a Nigerian investment platform that helps users save, invest and grow wealth through accessible plans and secure transactions."> 
  <meta name="author" content="GTX Nigeria"> 
  <meta name="robots" content="index,follow"> 
  <link rel="canonical" href="https://nvdgtx.com/main/grade"> 
  <link rel="icon" type="image/png" sizes="32x32" href="/assets/images/logo.jpg"> 
  <link rel="icon" type="image/png" sizes="16x16" href="/assets/images/logo.jpg"> 
  <link rel="apple-touch-icon" sizes="180x180" href="/assets/images/logo.jpg"> 
  <link rel="mask-icon" href="/assets/images/logo.jpg" color="rgba(0, 40, 7, 1)"> 
  <meta name="msapplication-TileImage" content="/assets/images/logo.jpg"> 
  <meta name="msapplication-TileColor" content="#ffffff"> 
  <link rel="manifest" href="/site.webmanifest"> 
  <meta name="theme-color" content="#008400ff"> 
  <meta name="csrf-token" content="DI0LkeFiFhYw4FgCCOu0IYuLIBQa5tH3xnGJVVd2"> 
  <meta property="og:type" content="website"> 
  <meta property="og:title" content="Login - GTX Nigeria"> 
  <meta property="og:description" content="GTX is a Nigerian investment platform that helps users save, invest and grow wealth through accessible plans and secure transactions."> 
  <meta property="og:url" content="https://nvdgtx.com/main/grade"> 
  <meta property="og:site_name" content="GTX Nigeria"> 
  <meta property="og:image" content="https://nvdgtx.com/assets/images/logo.jpg"> 
  <meta property="og:image:alt" content="GTX Nigeria logo"> 
  <meta property="og:image:width" content="1200"> 
  <meta property="og:image:height" content="630"> 
  <meta name="twitter:card" content="summary_large_image"> 
  <meta name="twitter:title" content="Login - GTX Nigeria"> 
  <meta name="twitter:description" content="GTX is a Nigerian investment platform that helps users save, invest and grow wealth through accessible plans and secure transactions."> 
  <meta name="twitter:image" content="https://nvdgtx.com/assets/images/logo.jpg"> 
  <meta name="twitter:image:alt" content="GTX Nigeria logo"> 
  <link rel="preconnect" href="https://fonts.googleapis.com"> 
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin=""> 
  <!-- <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600;700&display=swap" rel="stylesheet" />
  <link rel="preconnect" href="https://fonts.googleapis.com" />
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
  <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600;700&display=swap" rel="stylesheet" /> --> 
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css"> 
  <link href="https://cdn.jsdelivr.net/npm/remixicon@3.5.0/fonts/remixicon.css" rel="stylesheet"> 
  <style>

    /* Reset / base */
    * { margin: 0; padding: 0; box-sizing: border-box; font-family: 'Poppins', sans-serif; }
    body { min-height: 100vh; background: linear-gradient(135deg, #0f2a1aff, #036320ff); color: white; overflow-x: hidden; }
    .app { width:100%; max-width:520px; margin:0 auto; position:relative; }
    .green-filter {
      filter: hue-rotate(260deg) saturate(150%);
    }

  </style> 
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/layui/2.5.7/css/layui.css">

<style>
/* ====== BASIC STYLES ====== */
body{margin:0;font-family:'Poppins',sans-serif;background:linear-gradient(135deg,#0f2a1a,#036320);color:white;overflow-x:hidden;}
.app{width:100%;max-width:520px;margin:0 auto;padding-bottom:100px;}
.header{position:fixed;top:0;left:0;right:0;background:linear-gradient(to right,#0f2a12,#258a1e);
display:flex;justify-content:space-between;align-items:center;padding:16px;z-index:50;}
.header h1{font-size:18px;font-weight:500;}
.topup{color:#83ff81;font-size:14px;font-weight:500;background:none;border:none;cursor:pointer;}
.summary-card{background:url('/assets/images/bgg.png');background-size:cover;border-radius:16px;padding:20px;margin-top:80px;margin-bottom:24px;}
.summary-flex{display:flex;justify-content:space-between;align-items:center;}
.summary-item{text-align:center;}
.summary-item h3{font-size:13px;margin-bottom:6px;}
.summary-value{font-size:25px;font-weight:700;color:#facc15;}
.divider{width:1px;height:64px;background:rgba(255,255,255,0.2);}
.info-box{background:rgba(40,235,37,0.4);border-radius:12px;padding:16px;margin-bottom:24px;font-size:14px;}
.claim-btn{width:100%;background:linear-gradient(to right,#129a00,#056b00);color:white;border:none;
border-radius:9999px;font-size:16px;font-weight:500;padding:14px 0;box-shadow:0 4px 12px rgba(37,235,133,0.4);cursor:pointer;margin-bottom:24px;transition:0.3s;}
.claim-btn:hover{opacity:0.9;}
.tabs{display:flex;background:rgba(255,255,255,0.1);border-radius:9999px;padding:4px;margin-bottom:24px;}
.tab{flex:1;text-align:center;padding:10px 0;border-radius:9999px;cursor:pointer;font-size:14px;position:relative;transition:0.3s;}
.tab.active{background:white;color:#1e3a8a;font-weight:600;}
.tab-count{position:absolute;top:-6px;right:16px;background:#facc15;color:#111;font-size:10px;width:18px;height:18px;border-radius:50%;display:flex;justify-content:center;align-items:center;font-weight:600;}
.investment-card{background:white;color:#111827;border-radius:16px;padding:16px;margin-bottom:16px;box-shadow:0 4px 10px rgba(0,0,0,0.1);}
.card-header{display:flex;gap:12px;margin-bottom:12px;}
.card-header img{width:80px;height:60px;object-fit:cover;border-radius:8px;}
.card-details h3{font-size:14px;font-weight:600;margin-bottom:6px;}
.card-details p{margin:2px 0;font-size:13px;}
.card-stats{display:flex;justify-content:space-between;align-items:center;flex-wrap:wrap;margin-top:10px;}
.card-footer{display:flex;justify-content:space-between;align-items:center;border-top:1px solid #e5e7eb;padding-top:10px;margin-top:8px;font-size:13px;}
.status-dot{width:8px;height:8px;border-radius:50%;margin-right:6px;}
.status-dot.green{background:#22c55e;}
.status-dot.orange{background:#f97316;}
.status-dot.red{background:#ef4444;}
.countdown{font-size:13px;color:#065f46;margin-top:4px;}
.expired-text{color:#ef4444;font-weight:600;}
.empty-state{text-align:center;margin-top:40px;}
.alert-message{padding:10px;border-radius:8px;margin-bottom:16px;}
.alert-message.success{background:#22c55e;color:white;}
.alert-message.error{background:#ef4444;color:white;}
.loading{position:fixed;top:0;left:0;width:100%;height:100%;background:rgba(0,0,0,0.5);z-index:999;display:flex;justify-content:center;align-items:center;color:white;font-size:20px;}
</style>
</head>
<body>
    <div id="apdLoadingOverlay" aria-hidden="true" role="status" style="display:none;"> 
    <div class="apd-loading-wrap" id="apdLoadingBox" aria-hidden="true"> 
     <div class="apd-spinner" aria-hidden="true"></div> 
    </div> 
   </div> 
   <style>
  /* Inline styles specific to loader partial */
  #apdLoadingOverlay {
    position: fixed;
    inset: 0;
    display: flex;
    align-items: center;
    justify-content: center;
    z-index: 999999999;
    background: rgba(0,0,0,0.45);
  }
  .apd-loading-wrap {
    width: 100px;
    height: 100px;
    min-width: 100px;
    min-height: 100px;
    border-radius: 12px;
    background: rgba(255,255,255,0.03);
    display: flex;
    align-items: center;
    justify-content: center;
    box-shadow: 0 8px 24px rgba(0,0,0,0.45), inset 0 1px 0 rgba(255,255,255,0.02);
    backdrop-filter: blur(6px);
  }
  .apd-spinner {
    width: 56px;
    height: 56px;
    border-radius: 50%;
    border: 4px solid rgba(255,255,255,0.14);
    border-top-color: #ffffff;
    animation: apd-spin 900ms linear infinite;
    box-sizing: border-box;
  }
  @keyframes apd-spin {
    0% { transform: rotate(0deg); }
    100% { transform: rotate(360deg); }
  }
</style> 
   <script>
  // Expose loader control functions to global scope
  (function () {
    const overlay = document.getElementById('apdLoadingOverlay');
    const box = document.getElementById('apdLoadingBox');

    if (!window.apdLoader) {
      window.apdLoader = {
        show: function () {
          overlay.style.display = 'flex';
          overlay.setAttribute('aria-hidden', 'false');
          // automatically hide after 3 seconds
          setTimeout(function() {
            overlay.style.display = 'none';
            overlay.setAttribute('aria-hidden', 'true');
          }, 500);
        },
        hide: function () {
          overlay.style.display = 'none';
          overlay.setAttribute('aria-hidden', 'true');
        },
        // toggle convenience
        toggle: function (force) {
          if (typeof force === 'boolean') {
            return force ? this.show() : this.hide();
          }
          overlay.style.display = overlay.style.display === 'none' ? 'flex' : 'none';
        }
      };
    }
  })();
</script> 
<div class="app">
<div class="header">
<h1>My Devices</h1>
<button class="topup" onclick="window.location='{{ url('user/recharge') }}'">Top Up</button>
</div>

<div class="container" style="padding:0 16px;margin-top:80px;margin-bottom:120px;">

<div class="summary-card">
<div class="summary-flex">
<div class="summary-item">
<h3>Total Products</h3>
<div class="summary-value">{{ $purchases->count() }}</div>
</div>
<div class="divider"></div>
<div class="summary-item">
<h3>Total Receivable</h3>
<div class="summary-value">{{ price($totalReceivable,2) }}</div>
</div>
</div>
</div>

<div class="info-box">
After purchasing a device, you can claim all income in one click.
</div>

<!-- ALERT MESSAGE -->
<div id="messageBox" class="alert-message" style="display:none;"></div>

<!-- LOADING -->
<div class="loading" style="display:none;">Loading...</div>

<!-- ONE CLICK CLAIM BUTTON -->
<button id="claim-income" class="claim-btn">Claim All Income</button>

<div class="tabs">
<div class="tab active" id="tabActive" onclick="showTab('active')">In Progress <span class="tab-count">{{ $active->count() }}</span></div>
<div class="tab" id="tabCompleted" onclick="showTab('completed')">Completed <span class="tab-count">{{ $completed->count() }}</span></div>
</div>

<!-- ACTIVE DEVICES -->
<div id="activeList">
@forelse($active as $purchase)
@php
$pkg = $purchase->package;
$nextIncome = $pkg->drop_type=='daily' ? Carbon::parse($purchase->date) : Carbon::parse($purchase->created_at)->addDays($pkg->validity);
$totalProfit = $pkg->drop_type=='daily' ? $purchase->daily_income * $pkg->validity : $pkg->commission_with_avg_amount;
@endphp
<div class="investment-card">
<div class="card-header">
<img src="{{ asset($pkg->photo) }}" alt="device" style="width: 80px; height: 60px; object-fit: cover; border-radius: 8px;">
<div class="card-details">
<h3>{{ $pkg->name ?? 'Unnamed Device' }}</h3>
<p>{{ price($purchase->amount,2) }}</p>
<p>Total Profit: {{ price($totalProfit,2) }}</p>
<p>Next Income: <span class="countdown" data-time="{{ $nextIncome }}"></span></p>
</div>
</div>
<div class="card-stats">
<div>
<div class="revenue">{{ price($purchase->receive_able_amount,2) }}</div>
<div>Receivable</div>
</div>
</div>
<div class="card-footer">
<span><span class="status-dot orange"></span>Active</span>
<span>{{ $purchase->created_at->format('d M, Y h:i A') }}</span>
</div>
</div>
@empty
<div class="empty-state">
<img src="/assets/images/no1.png" style="width:100px;opacity:0.8">
<p>No Active Devices</p>
</div>
@endforelse
</div>

<!-- COMPLETED DEVICES -->
<div id="completedList" style="display:none;">
@forelse($completed as $purchase)
@php
$pkg = $purchase->package;
$totalProfit = $pkg->drop_type=='daily' ? $purchase->daily_income * $pkg->validity : $pkg->commission_with_avg_amount;
$expiredDate = Carbon::parse($purchase->updated_at);
@endphp
<div class="investment-card">
<div class="card-header">
<img src="{{ asset($pkg->image ?? '/assets/images/no1.png') }}" alt="device">
<div class="card-details">
<h3>{{ $pkg->name ?? 'Unnamed Device' }}</h3>
<p>₦{{ number_format($purchase->amount,2) }}</p>
<p>Total Profit: ₦{{ number_format($totalProfit,2) }}</p>
<p>Expired: <span class="expired-text">{{ $expiredDate->format('d M, Y') }}</span></p>
</div>
</div>
<div class="card-stats">
<div class="revenue">₦{{ number_format($purchase->total_income ?? $purchase->receive_able_amount,2) }}</div>
<div>Total Earned</div>
</div>
<div class="card-footer">
<span><span class="status-dot green"></span>Completed</span>
<span>{{ $expiredDate->format('d M, Y h:i A') }}</span>
</div>
</div>
@empty
<div class="empty-state">
<img src="/assets/images/no1.png" style="width:100px;opacity:0.8">
<p>No Completed Devices</p>
</div>
@endforelse
</div>

</div>
</div>
 </main> 
   <nav class="apd-bottom-nav" aria-label="bottom navigation"> 
    <div class="apd-nav-inner"> 
     <a class="apd-nav-item " href="/dashboard"> 
      <svg viewbox="0 0 24 24" width="20" height="20" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round"> 
       <path d="M3 11.5L12 5l9 6.5"></path> 
       <path d="M5.5 21V12.5h13V21"></path> 
       <path d="M9 21v-6h6v6"></path> 
      </svg> <span>Home</span> </a> 
     <a class="apd-nav-item  active " href="/vip"> 
      <svg viewbox="0 0 24 24" width="20" height="20" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round"> 
       <rect x="2.5" y="6.5" width="19" height="11" rx="2"></rect> 
       <circle cx="17" cy="11.5" r="1.6"></circle> 
       <path d="M7 11.5h4"></path> 
      </svg> <span>Income</span> </a> 
     <a class="apd-nav-item " href="/salary"> 
      <svg viewbox="0 0 26 26" width="28" height="28" xmlns="http://www.w3.org/2000/svg"> 
       <rect x="5" y="14" width="3.5" height="7" rx="0.6" fill="currentColor" opacity="0.95"></rect> 
       <rect x="11" y="10" width="3.5" height="11" rx="0.6" fill="currentColor" opacity="0.95"></rect> 
       <rect x="17" y="6" width="3.5" height="15" rx="0.6" fill="currentColor" opacity="0.95"></rect> 
       <polyline points="5,16 9,13 13,12 17,8 21,9" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round"></polyline> 
       <circle cx="21" cy="9" r="1.2" fill="currentColor"></circle> 
      </svg> <span>Salary</span> </a> 
     <a class="apd-nav-item " href="/my-team"> 
      <svg viewbox="0 0 24 24" width="20" height="20" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round"> 
       <path d="M14 8.5a3 3 0 1 0-6 0"></path> 
       <path d="M3.5 20.5c1.6-3 4.2-4.5 7.5-4.5h1"></path> 
       <path d="M19 9v4M21 11h-4"></path> 
      </svg> <span>Invite</span> </a> 
     <a class="apd-nav-item " href="/my-profile"> 
      <svg viewbox="0 0 24 24" width="20" height="20" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round"> 
       <circle cx="12" cy="8.2" r="3"></circle> 
       <path d="M4.5 20.5c1.8-3.6 5.2-5 7.5-5s5.7 1.4 7.5 5"></path> 
      </svg> <span>Mine</span> </a> 
    </div> 
   </nav> 
   <style>
  .apd-bottom-nav {
    position: fixed;
    left: 0;
    right: 0;
    bottom: 0;
    z-index: 1050;
    padding: 8px 12px;
    max-width: 420px;
    margin: 0 auto;
    background: #004a11ff;
    border-top: 1px solid #30ff52ff;
    backdrop-filter: blur(6px);
  }

  .apd-nav-inner {
    max-width: 900px;
    margin: 0 auto;
    display: flex;
    gap: 6px;
    justify-content: space-between;
    align-items: center;
  }

  .apd-nav-item {
    display: flex;
    flex-direction: column;
    align-items: center;
    text-decoration: none;
    color: rgba(255,255,255,0.7);
    font-size: 11px;
    width: 56px;
    padding: 6px 2px;
    transition: all 0.2s ease;
  }

  .apd-nav-item svg {
    stroke: currentColor;
    transition: all 0.2s ease;
  }

  .apd-nav-item.active {
    color: #30ff6bff; /* main page color */
  }

  .apd-nav-item.active svg {
    stroke: #30ff6bff;
  }

  .apd-nav-item:hover {
    color: #30ff6bff;
  }

  @media (min-width:720px) {
    .apd-nav-inner { justify-content: center; gap: 28px; }
  }
</style> 
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/layui/2.5.7/layui.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/canvas-confetti@1.5.1/dist/confetti.browser.min.js"></script>

<script>
layui.use(['layer'], function(){
  var layer = layui.layer;

  // ONE CLICK CLAIM AJAX
  $('#claim-income').click(function(){
    var button = $(this);
    button.prop('disabled', true);
    $('.loading').show();
    $('#messageBox').hide();

    $.ajax({
      url: "{{ route('user.mining.received_amount') }}",
      method: "POST",
      headers: {'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')},
      data: {},
      success: function(res){
        $('.loading').hide();
        button.prop('disabled', false);
        $('#messageBox').show();

        if(res.status){
          $('#messageBox').text(res.success).addClass('success').removeClass('error');
          layer.msg(res.success, {icon:1});
          // Reset total receivable
          $('.revenue').text('₦0');
          showConfetti();
        } else {
          $('#messageBox').text(res.error).addClass('error').removeClass('success');
          layer.msg(res.error, {icon:2});
        }
      },
      error: function(){
        $('.loading').hide();
        button.prop('disabled', false);
        $('#messageBox').show().text("An error occurred.").addClass('error').removeClass('success');
      }
    });
  });
});

// Tabs switch
function showTab(type){
  $('#activeList').toggle(type==='active');
  $('#completedList').toggle(type==='completed');
  $('#tabActive').toggleClass('active', type==='active');
  $('#tabCompleted').toggleClass('active', type==='completed');
}

// Countdown timer
document.querySelectorAll('.countdown').forEach(el=>{
  let nextTime = new Date(el.dataset.time).getTime();
  setInterval(()=>{
    let distance = nextTime - new Date().getTime();
    if(distance <=0){
      el.textContent='Income Ready!';
      el.style.color='#22c55e';
    } else {
      let h=Math.floor((distance % (1000*60*60*24))/(1000*60*60));
      let m=Math.floor((distance % (1000*60*60))/(1000*60));
      let s=Math.floor((distance % (1000*60))/1000);
      el.textContent=`${h}h ${m}m ${s}s`;
      el.style.color='#065f46';
    }
  },1000);
});

// Confetti effect
function showConfetti() {
  const duration = 2 * 1000;
  const animationEnd = Date.now() + duration;
  const confettiSettings = { startVelocity: 30, spread: 360, ticks: 60, zIndex: 1000 };
  const interval = setInterval(function() {
    if (Date.now() > animationEnd) return clearInterval(interval);
    confetti(Object.assign({}, confettiSettings, {
      particleCount: 50,
      origin: { x: Math.random(), y: Math.random() - 0.2 }
    }));
  }, 200);
}
</script>
<script>
    window.OneOk = window.OneOk || {};
    window.OneOk.formatNaira = function(n){
      return '₦' + Number(n).toLocaleString('en-US');
    };

    document.querySelectorAll('a').forEach(a => {
      a.addEventListener('click', function (evt) {
        // ignore modified clicks (open in new tab/window)
        if (evt.ctrlKey || evt.metaKey || evt.shiftKey || evt.altKey || evt.button === 1) return;

        // ignore anchors that do nothing or internal fragment links
        const href = (a.getAttribute('href') || '').trim();
        if (!href || href.startsWith('#') || href === 'javascript:void(0)') return;

        if (window.apdLoader && typeof window.apdLoader.show === 'function') {
          window.apdLoader.show();
        }
      });
    });

  </script> 
 </body>
</html>
