<!DOCTYPE html>
<html lang="en">
<head> 
  <meta charset="utf-8"> 
  <meta name="viewport" content="width=device-width,initial-scale=1"> 
  <title>GTX | Team members</title> 
  <link rel="icon" type="image/png" href="/assets/images/logo.jpg"> 
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css"> 
  <link href="https://cdn.jsdelivr.net/npm/remixicon@3.5.0/fonts/remixicon.css" rel="stylesheet"> 
  <style>
    *{margin:0;padding:0;box-sizing:border-box;font-family:'Poppins',sans-serif;}
    body{min-height:100vh;background:linear-gradient(135deg,#0f2a1aff,#036320ff);color:white;overflow-x:hidden;}
    .app{width:100%;max-width:520px;margin:0 auto;position:relative;}
    :root{
      --primary-1:#008c10ff;
      --primary-2:#1a7000ff;
      --muted:#6b7280;
      --card-bg:#fff;
      --radius:12px;
      --shadow:0 12px 30px rgba(6,18,34,0.06);
    }
    .container{max-width:980px;margin:14px auto;padding:16px;box-sizing:border-box;}
    .card{background:linear-gradient(180deg,var(--card-bg),#fbfdff);padding:5px;border-radius:12px;
          box-shadow:var(--shadow);border:1px solid rgba(6,18,34,0.04);}
    .tabs{display:flex;gap:8px;}
    .tab{flex:1;padding:8px 4px;border-radius:10px;text-align:center;font-weight:800;cursor:pointer;
         background:transparent;border:1px solid transparent;color:var(--muted);user-select:none; font-size: 11px; line-height: 1.2;}
    .tab.active{color:#fff;background:linear-gradient(90deg,var(--primary-1),var(--primary-2));
                box-shadow:0 18px 40px rgba(43,156,255,0.12);transform:translateY(-2px);}
    
    .valid-text { display: block; font-size: 9px; color: #FFD700; font-weight: bold; margin-top: 2px; }
    .tab.active .valid-text { color: #fff; }

    .list{display:none;flex-direction:column;gap:10px;margin-top:6px;}
    .list.active{display:flex;}
    .member{display:flex;gap:12px;align-items:center;justify-content:space-between;
            padding:10px;border-radius:10px;background:#fff;border:1px solid rgba(6,18,34,0.04);
            box-shadow:0 6px 18px rgba(6,18,34,0.04);}
    .empty{text-align:center;color:var(--muted);padding:18px 8px;}
    .header{display:flex;justify-content:space-between;align-items:center;
            padding:3rem 1rem 1rem;margin-top:-20px;}
    .header button{width:2rem;height:2rem;background:none;border:none;color:#fff;font-size:1.5rem;}
    .load-more{text-align:center;margin-top:20px;padding-bottom:20px;}
    .btn{background:rgba(255,255,255,0.1);border:none;color:white;padding:8px 20px;border-radius:20px;font-size:12px;}
  </style>
</head>

<body>
  <div class="app"> 
    <div class="header"> 
      <button onclick="history.back()"><i class="ri-arrow-left-line"></i></button> 
      <h1 style="font-size:1.1rem;font-weight:500;">Team members</h1> 
      <div style="width:2rem;height:2rem;"></div>
    </div> 

    <main id="app-main"> 
      <div class="container"> 
        <div class="card"> 
          <div class="tabs" role="tablist"> 
            <div class="tab" data-tab="level1">
                Team B
                <span class="valid-text">Valid: {{ $valid_purchase1 }}</span>
            </div> 
            <div class="tab active" data-tab="level2">
                Team C
                <span class="valid-text">Valid: {{ $valid_purchase2 }}</span>
            </div> 
            <div class="tab" data-tab="level3">
                Team D
                <span class="valid-text">Valid: {{ $valid_purchase3 }}</span>
            </div> 
          </div> 
        </div> 

        {{-- ✅ Team B --}}
        <div id="level1" class="list">
          @forelse($first_level_users as $user1)
            <div class="member">
              <div>
                <div style="font-weight:800;background:#9f1818ff;color:#fff;text-align:center;font-size:13px;padding:5px 2px;border-top-left-radius:15px;border-bottom-right-radius:15px;">Team B</div>
                <div style="font-weight:800;color:#02324c;font-size:13px;margin-top:10px;">
                  {{ $user1->phone ?? $user1->email }}
                  @if(\App\Models\Purchase::where('user_id', $user1->id)->exists())
                    <span style="color: green; font-size: 9px; display: block;">Valid ✅</span>
                  @endif
                </div>
              </div>
              <div style="flex:0 0 auto;text-align:right;min-width:110px;">
                <div style="font-weight:900;color:#042a4d;font-size:13px">
                  Max: <span style="color:#9f1818ff;">{{ price(\App\Models\Deposit::where('user_id',$user1->id)->where('status','approved')->sum('amount'),2) }}</span>
                </div>
                <div style="color:#042a4d;font-size:13px;margin-top:10px;">{{ $user1->created_at }}</div>
              </div>
            </div>
          @empty
            <div class="empty">No Team B members yet.</div>
          @endforelse
        </div>

        {{-- ✅ Team C (Active on Load) --}}
        <div id="level2" class="list active">
          @forelse($second_level_users as $user2)
            <div class="member">
              <div>
                <div style="font-weight:800;background:#036320;color:#fff;text-align:center;font-size:13px;padding:5px 2px;border-top-left-radius:15px;border-bottom-right-radius:15px;">Team C</div>
                <div style="font-weight:800;color:#02324c;font-size:13px;margin-top:10px;">
                  {{ $user2->phone ?? $user2->email }}
                  @if(\App\Models\Purchase::where('user_id', $user2->id)->exists())
                    <span style="color: green; font-size: 9px; display: block;">Valid ✅</span>
                  @endif
                </div>
              </div>
              <div style="flex:0 0 auto;text-align:right;min-width:110px;">
                <div style="font-weight:900;color:#042a4d;font-size:13px">
                  Max: <span style="color:#036320;">{{ price(\App\Models\Deposit::where('user_id',$user2->id)->where('status','approved')->sum('amount'),2) }}</span>
                </div>
                <div style="color:#042a4d;font-size:13px;margin-top:10px;">{{ $user2->created_at }}</div>
              </div>
            </div>
          @empty
            <div class="empty">No Team C members yet.</div>
          @endforelse
        </div>

        {{-- ✅ Team D --}}
        <div id="level3" class="list">
          @forelse($third_level_users as $user3)
            <div class="member">
              <div>
                <div style="font-weight:800;background:#0f2a1a;color:#fff;text-align:center;font-size:13px;padding:5px 2px;border-top-left-radius:15px;border-bottom-right-radius:15px;">Team D</div>
                <div style="font-weight:800;color:#02324c;font-size:13px;margin-top:10px;">
                  {{ $user3->phone ?? $user3->email }}
                  @if(\App\Models\Purchase::where('user_id', $user3->id)->exists())
                    <span style="color: green; font-size: 9px; display: block;">Valid ✅</span>
                  @endif
                </div>
              </div>
              <div style="flex:0 0 auto;text-align:right;min-width:110px;">
                <div style="font-weight:900;color:#042a4d;font-size:13px">
                  Max: <span style="color:#0f2a1a;">{{ price(\App\Models\Deposit::where('user_id',$user3->id)->where('status','approved')->sum('amount'),2) }}</span>
                </div>
                <div style="color:#042a4d;font-size:13px;margin-top:10px;">{{ $user3->created_at }}</div>
              </div>
            </div>
          @empty
            <div class="empty">No Team D members yet.</div>
          @endforelse
        </div>

        <div class="load-more">
          <button class="btn" disabled>No more members</button>
        </div>
      </div>
    </main>
  </div>

  <script>
    const tabs = document.querySelectorAll('.tab');
    const lists = document.querySelectorAll('.list');
    tabs.forEach(tab=>{
      tab.addEventListener('click',()=>{
        tabs.forEach(t=>t.classList.remove('active'));
        tab.classList.add('active');
        lists.forEach(list=>list.classList.remove('active'));
        document.getElementById(tab.dataset.tab).classList.add('active');
      });
    });
  </script>
</body>
</html>
