<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width,initial-scale=1">
<title>GTX | Customer Service</title>
<link rel="icon" type="image/png" href="/assets/images/logo.jpg">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
<link href="https://cdn.jsdelivr.net/npm/remixicon@3.5.0/fonts/remixicon.css" rel="stylesheet">

<style>
  * { margin: 0; padding: 0; box-sizing: border-box; font-family: 'Poppins', sans-serif; }
  body { min-height:100vh; background: linear-gradient(135deg, #0f2a1a, #036320); color: #fff; display:flex; justify-content:center; padding:20px; }
  .app { width:100%; max-width:520px; margin:0 auto; }

  .header { display:flex; justify-content: space-between; align-items:center; padding:2rem 1rem 1rem; }
  .header button { width:2rem; height:2rem; background:none; border:none; color:#fff; font-size:1.5rem; cursor:pointer; }
  .wave-icon { display:flex; justify-content:center; margin:2rem 0 1rem; }
  .wave-icon svg { color:#fff; animation: float 2s ease-in-out infinite; }
  @keyframes float { 0%,100%{transform:translateY(0);} 50%{transform:translateY(-6px);} }

  .greeting { text-align:center; margin-bottom:2rem; }
  .greeting h2 { font-size:2rem; margin-bottom:0.5rem; }
  .greeting p { font-size:1rem; opacity:0.8; padding:0 1.5rem; line-height:1.6; }

  .support-options { padding:0 1rem; display:flex; flex-direction:column; gap:1rem; }

  .card { background:#fff; color:#111; border-radius:1.2rem; padding:1rem; display:flex; justify-content:space-between; align-items:center; cursor:pointer; transition:transform 0.3s ease; }
  .card:hover { transform: translateY(-3px); }
  .card-left { display:flex; align-items:center; }
  .card-left .icon { width:3rem; height:3rem; border-radius:50%; display:flex; align-items:center; justify-content:center; margin-right:1rem; flex-shrink:0; font-size:1.4rem; color:#fff; }
  .card-left .icon.green { background:#25D366; }  /* WhatsApp green */
  .card-left .icon.blue { background:#007bff; }   /* Telegram blue */
  .card-left h3 { font-size:1rem; margin:0; }
  .card-left p { font-size:0.85rem; color:#555; margin-top:2px; }

  .tag { background:#28a745; color:#fff; font-size:0.8rem; font-weight:500; padding:0.4rem 1rem; border-radius:999px; }

  @media (max-width:600px){
    .greeting h2 { font-size:1.7rem; }
    .card { padding:0.8rem; }
    .tag { font-size:0.7rem; }
  }
</style>
</head>
<body>
  <div class="app">

    <div class="header">
      <button onclick="window.history.back()"><i class="ri-arrow-left-line"></i></button>
      <h1 style="font-size:1.1rem; font-weight:500;">Customer Service</h1>
      <div style="width:2rem;"></div>
    </div>

    <div class="wave-icon">
      <svg width="60" height="40" viewbox="0 0 60 40" fill="none">
        <path d="M5 20C15 10, 25 30, 35 20C45 10, 55 30, 55 20" stroke="currentColor" stroke-width="3" stroke-linecap="round" fill="none"></path>
      </svg>
    </div>

    <div class="greeting">
      <h2>Hello. 👋</h2>
      <p>I'm your Customer Service Assistant. How can I help you?</p>
    </div>

    <div class="support-options">
      <!-- WhatsApp Manager 1 -->
      <div class="card" onclick="window.location.href='https://wa.me/1234567890'">
        <div class="card-left">
          <div class="icon green"><i class="fab fa-whatsapp"></i></div>
          <div>
            <h3>WhatsApp Customer Service 1</h3>
          </div>
        </div>
        <div class="tag">WhatsApp</div>
      </div>

      <!-- WhatsApp Manager 2 -->
      <div class="card" onclick="window.location.href='https://wa.me/9755034816'">
        <div class="card-left">
          <div class="icon green"><i class="fab fa-whatsapp"></i></div>
          <div>
            <h3>WhatsApp Customer Service 2</h3>
          </div>
        </div>
        <div class="tag">WhatsApp</div>
      </div>

      <!-- Telegram Channel -->
      <div class="card" onclick="window.location.href='https://t.me/9755034816'">
        <div class="card-left">
          <div class="icon blue"><i class="ri-telegram-line"></i></div>
          <div>
            <h3>NVIDIA GTX Official Channel</h3>
          </div>
        </div>
        <div class="tag">Telegram</div>
      </div>
    </div>

  </div>
</body>
</html>