<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width,initial-scale=1">
<title>GTX | Salary</title>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
<link href="https://cdn.jsdelivr.net/npm/remixicon@3.5.0/fonts/remixicon.css" rel="stylesheet">
<style>
* { margin:0; padding:0; box-sizing:border-box; font-family:'Poppins',sans-serif; }
body { min-height:100vh; background: linear-gradient(135deg,#0f2a1aff,#036320ff); color:white; overflow-x:hidden; }
.app { width:100%; max-width:520px; margin:0 auto; position:relative; }
.header { position:fixed; top:0; left:0; right:0; background:linear-gradient(to right,#0f2a12ff,#258a1eff); display:flex; justify-content:space-between; align-items:center; padding:16px; z-index:50; }
.header h1 { font-size:18px; font-weight:500; }
.header button { background:none; border:none; color:white; font-size:20px; cursor:pointer; }
.header .topup { color:#68fa60ff; font-size:14px; font-weight:500; background:none; border:none; cursor:pointer; }
.vip-card { background:url('/assets/images/slr.png'); background-size:cover; border-radius:10px; padding:1rem; margin:0.75rem; color:#1f2937; margin-top:80px; }
.vip-card .content { display:flex; justify-content:space-between; align-items:flex-start; }
.vip-card h2,h3,p{margin:0;} 
.levels { padding:0 0.75rem 2rem; display:flex; flex-direction:column; gap:0.75rem; margin-bottom:50px; }
.level-card { background:white; border-radius:10px; padding:0.75rem; color:#1f2937; }
.level-top { display:flex; justify-content:space-between; align-items:flex-start; margin-bottom:0.5rem; }
.level-top p { font-size:0.75rem; color:#374151; line-height:1.3; flex:1; margin-right:0.5rem; }
.level-badge { position:relative; width:3rem; height:3rem; border-radius:50%; background:linear-gradient(to bottom right,#facc15,#fb923c); display:flex; align-items:center; justify-content:center; }
.level-badge-inner { width:2.3rem; height:2.3rem; border-radius:50%; background:linear-gradient(to bottom right,#fde047,#fb923c); display:flex; align-items:center; justify-content:center; color:white; font-weight:700; font-size:0.65rem; }
.crown { position:absolute; top:-3px; left:50%; transform:translateX(-50%); width:1rem; height:0.4rem; background:linear-gradient(to right,#ef4444,#f97316); border-radius:8px 8px 0 0; display:flex; align-items:center; justify-content:center; }
.crown::after { content:""; width:0.25rem; height:0.25rem; background:#facc15; border-radius:50%; }
.side-dot { position:absolute; top:3px; width:0.45rem; height:0.45rem; border-radius:50%; background:linear-gradient(to right,#ef4444,#f97316); }
.side-dot.left { left:-3px; } .side-dot.right { right:-3px; }
.intel { position:absolute; bottom:-5px; left:50%; transform:translateX(-50%); background:#ef4444; color:white; font-size:0.55rem; padding:1px 5px; border-radius:999px; font-weight:500; }
.level-bottom { display:flex; justify-content:space-between; align-items:center; }
.level-bottom span { font-size:0.75rem; color:#4b5563; }
.level-bottom button { border:none; padding:0.3rem 0.8rem; border-radius:999px; font-size:0.7rem; font-weight:500; cursor:pointer; }
@media (max-width:500px) { body{font-size:12px;} .level-badge{width:2.8rem;height:2.8rem;} .level-badge-inner{width:2.1rem;height:2.1rem;font-size:0.6rem;} }
</style>
</head>
<body>
<div class="app" role="main" aria-label="app content">

    <!-- Header -->
    <div class="header">
        <button>&nbsp;</button>
        <h1>Salary</h1>
        <button class="topup" onclick="window.location.href='{{ url('/main/invite') }}'">My Team</button>
    </div>

    <!-- VIP Card -->
    <div class="vip-card">
        <div class="content">
            <div>
                <p>Current Level</p>
                <h2>VIP {{ auth()->user()->vip_level ?? 0 }}</h2>
                <p>Total Direct Referrals</p>
                <h3>{{ auth()->user()->referrals()->count() }}</h3>
                <p>Qualified Referrals (&gt;=10,000)</p>
                <h3>{{ auth()->user()->qualifiedReferrals(10000)->count() }}</h3>
            </div>
        </div>
    </div>

    <!-- Levels / Tasks -->
    <div class="levels">
        @foreach($tasks as $task)
@php
    $completedCount = $task->completedCount(auth()->user());
    $eligible = $task->isEligible(auth()->user());
    $alreadyClaimed = \App\Models\TaskRequest::where('user_id', auth()->id())
        ->where('task_id', $task->id)
        ->where('last_paid_month', now()->format('Y-m'))
        ->exists();
@endphp
<div class="level-card">
    <div class="level-top">
        <p>
            Invite {{ $task->required_invites }} A-grade subordinates
            and if they purchase {{ price($task->required_purchase) }} or more,
            you will be promoted to VIP{{ $task->level }}.
            Reward: {{ price($task->bonus) }} Monthly | Extra profit: {{ $task->extra_profit }}%
        </p>
        <div class="level-badge">
            <div class="level-badge-inner">LV {{ $task->level }}</div>
            <div class="crown"></div>
            <div class="side-dot left"></div>
            <div class="side-dot right"></div>
            <div class="intel">{{ $task->vip_level_name ?? 'NVIDIA' }}</div>
        </div>
    </div>
    <div class="level-bottom">
        <span>{{ $completedCount }}/{{ $task->required_invites }}</span>
        <form method="POST" action="{{ url('/grade/claim/'.$task->id) }}">
            @csrf
            <button type="submit" {{ ($eligible && !$alreadyClaimed) ? '' : 'disabled' }}
                style="background: {{ ($eligible && !$alreadyClaimed) ? '#68fa60ff' : '#e5e7eb' }};
                       color: {{ ($eligible && !$alreadyClaimed) ? '#1f2937' : '#6b7280' }};">
                {{ $eligible ? ($alreadyClaimed ? 'Already Claimed' : 'Claim Reward') : 'Not Eligible' }}
            </button>
        </form>
    </div>
</div>
@endforeach

    </div>

    <!-- Regional Manager Card -->
    <div style="width:100%;margin:18px auto;padding:18px;border-radius:14px;background:linear-gradient(180deg,#ffffff,#fbfbff);box-shadow:0 10px 30px rgba(2,6,23,0.06);border:1px solid rgba(15,23,42,0.04);font-family:Inter, system-ui, -apple-system, 'Segoe UI', Roboto, 'Helvetica Neue', Arial;">
        <div style="display:flex;gap:20px;align-items:stretch;flex-wrap:wrap;">
            <div style="display:flex;flex-direction:column;align-items:center;flex:1;">
                <div style="display:flex;align-items:center;gap:12px;margin-bottom:6px;">
                    <div style="width:54px;height:54px;border-radius:12px;background:linear-gradient(135deg,#0b84ff,#7c3aed);display:flex;align-items:center;justify-content:center;box-shadow:0 6px 18px rgba(11,132,255,0.14);">
                        <i class="fa fa-user-tie" style="color:white;font-size:28px;"></i>
                    </div>
                    <div>
                        <div style="font-size:16px;color:#0f172a;font-weight:700;">Regional Manager</div>
                        <div style="font-size:13px;color:#6b7280;">Apply when 10 A-level members reach VIP 7</div>
                    </div>
                </div>
                <p style="margin:12px 0 14px;color:#374151;font-size:14px;line-height:1.5;">
                    Managers receive a monthly salary of <strong style="color:#0b84ff;">1,500,000 NGN</strong> 
                    and <strong style="color:#7c3aed;">5% commission</strong> on daily profit. Applications are reviewed manually.
                </p>
                <div style="display:flex;gap:12px;align-items:center;flex-wrap:wrap;width:100%;">
                    <div style="background:#f8fafc;padding:10px 14px;border-radius:10px;border:1px solid #eef2ff;flex:1;min-width:170px;">
                        <div style="font-size:12px;color:#64748b;">A-level VIP 7 members</div>
                        <div style="font-size:20px;color:#0f172a;font-weight:700;margin-top:6px;">{{ $userVip7Count ?? 0 }}</div>
                        <div style="font-size:12px;color:#94a3b8;margin-top:4px;">Required: <strong>10</strong></div>
                    </div>
                    <div style="flex:2;min-width:220px;">
                        <div style="height:12px;background:#eef2ff;border-radius:999px;overflow:hidden;">
                            <div style="width:{{ min(100,($userVip7Count ?? 0)/10*100) }}%;height:100%;background:linear-gradient(90deg,#0b84ff,#7c3aed);transition:width .4s ease;"></div>
                        </div>
                        <div style="font-size:12px;color:#64748b;margin-top:6px;">
                            Progress: <strong style="color:#0f172a;">{{ min(100,($userVip7Count ?? 0)/10*100) }}%</strong>
                        </div>
                    </div>
                </div>
                <div style="margin-top:16px;width:100%;">
                    <form method="POST" action="{{ url('/regional/apply') }}">
                        @csrf
                        <button type="submit"
                            {{ ($userVip7Count ?? 0) >= 10 ? '' : 'disabled' }}
                            style="padding:12px 18px; border-radius:10px; width: 100%; border: none; font-weight:700; font-size:14px; cursor:pointer; background: {{ ($userVip7Count ?? 0) >= 10 ? '#68fa60ff' : '#eef2ff' }}; color: {{ ($userVip7Count ?? 0) >= 10 ? '#1f2937' : '#94a3b8' }};">
                            Apply for Regional Manager
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>

@include('alert-message')

</div>
</body>
</html>
