
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>GTX | Deposit History</title>
<link rel="icon" type="image/png" sizes="32x32" href="{{ asset('assets/images/logo.jpg') }}">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
<link href="https://cdn.jsdelivr.net/npm/remixicon@3.5.0/fonts/remixicon.css" rel="stylesheet">
<style>

    /* Reset / base */
    * { margin: 0; padding: 0; box-sizing: border-box; font-family: 'Poppins', sans-serif; }
    body { min-height: 100vh; background: linear-gradient(135deg, #0f2a1aff, #036320ff); color: white; overflow-x: hidden; }
    .app { width:100%; max-width:520px; margin:0 auto; position:relative; }
    .green-filter {
      filter: hue-rotate(260deg) saturate(150%);
    }

  </style> 
<style>
   /* { margin:0; padding:0; box-sizing:border-box; font-family:'Poppins', sans-serif; }
    body { min-height:100vh; background: linear-gradient(135deg,#0f2a1aff,#036320ff); color:white; overflow-x:hidden; }
    .app { width:100%; max-width:520px; margin:0 auto; position:relative; padding-bottom:50px; }*/

    /* Header */
    .header { display:flex; justify-content:space-between; align-items:center; padding:3rem 1rem 1rem; margin-top:-20px; }
    .header button { width:2rem; height:2rem; background:none; border:none; color:#fff; cursor:pointer; font-size:1.5rem; }

    /* Transactions */
    .transactions { padding:0 16px 10px; }
    .transaction { border-radius:16px; padding:16px; margin-bottom:12px; background:rgba(255,255,255,0.05); }
    .transaction .top { display:flex; justify-content:space-between; align-items:center; }
    .left { display:flex; align-items:center; gap:12px; }
    .icon-bg { width:40px; height:40px; background:rgba(255,255,255,0.2); border-radius:50%; display:flex; align-items:center; justify-content:center; }
    .inner-icon { width:20px; height:20px; background:white; border-radius:6px; display:flex; align-items:center; justify-content:center; }
    .inner-bar { width:10px; height:16px; background:#49eb25ff; border-radius:4px; }
    .details h3 { font-size:14px; font-weight:500; margin:0; }
    .details p { font-size:10px; color:rgba(255,255,255,0.7); margin:2px 0 0; }
    .amount { font-size:13px; font-weight:600; }
    .amount.secondary { color:#ccc; text-align:right; font-size:12px; }

    /* Empty */
    .empty { text-align:center; color:rgba(255,255,255,0.6); margin-top:60px; font-size:15px; }
    .empty img { max-width:120px; margin-bottom:12px; }

    /* Load More */
    .load-more { display:flex; justify-content:center; margin-top:5px; margin-bottom:50px; }
    .load-more button { padding:10px 14px; border-radius:10px; font-weight:700; cursor:pointer; border:0; background:white; color:#007718ff; }

    @media (max-width:600px){ .transaction{padding:14px;} .amount{font-size:13px;} }

</style>
</head>
<body>
<div class="app">

    {{-- Header --}}
    <div class="header">
        <button onclick="goBack()"><i class="ri-arrow-left-line"></i></button>
        <h1 style="font-size:1.1rem; font-weight:500;">Deposit History</h1>
        <div style="width:2rem; height:2rem;"></div>
    </div>

    <script>
        function goBack(){ window.history.back(); }
    </script>

    <main id="app-main">
        <div class="apd-deposit-wrap">
            <section class="apd-deposit-card" aria-labelledby="depositHeading">
                <div class="transactions" id="depositContainer">

                    @php
                        $deposits = \App\Models\Deposit::where('user_id', auth()->id())
                                    ->orderByDesc('id')
                                    ->take(10)
                                    ->get();
                    @endphp

                    @if($deposits->count() > 0)
                        @foreach($deposits as $deposit)
                            <div class="transaction" data-type="{{ strtolower($deposit->method_name) }}">
                                <div class="top">
                                    <div class="left">
                                        <div class="icon-bg">
                                            <div class="inner-icon">
                                                <div class="inner-bar"></div>
                                            </div>
                                        </div>
                                        <div class="details">
                                            <h3 style="text-transform: capitalize">
                                                Deposit
                                                <span style="color:
                                                    @if($deposit->status == 'pending') #c68300ff
                                                    @elseif($deposit->status == 'approved') #00c676
                                                    @else #ff3b3b @endif">
                                                    &nbsp;&nbsp;({{ ucfirst($deposit->status) }})
                                                </span>
                                            </h3>
                                            <p>{{ \Carbon\Carbon::parse($deposit->created_at)->format('d/m/Y H:i:s') }}</p>
                                        </div>
                                    </div>
                                    <div class="right">
                                        <div class="amount">+{{ price($deposit->final_amount,2) }}</div>
                                        @if($deposit->amount != $deposit->final_amount)
                                            <div class="amount secondary">+${{ number_format($deposit->amount,4) }}</div>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    @else
                        <div class="empty">
                            <img src="/assets/images/no1.png" style="width: 200px" class="green-filter" ="No deposits">
                            <p>No deposit records yet</p>
                        </div>
                    @endif

                </div>

                @if($deposits->count() > 0)
                    <div class="load-more" id="loadMoreWrap">
                        <button id="loadMoreBtn">Load More</button>
                    </div>
                @endif
            </section>
        </div>
    </main>
</div>

<script>
document.getElementById('loadMoreBtn')?.addEventListener('click', function(){
    const container = document.getElementById('depositContainer');
    let offset = container.children.length;

    fetch('{{ url("deposit.loadmore") }}?offset=' + offset)
    .then(res => res.json())
    .then(data => {
        if(data.length === 0){
            document.getElementById('loadMoreWrap').style.display = 'none';
            return;
        }
        data.forEach(d => {
            const div = document.createElement('div');
            div.className = 'transaction';
            div.innerHTML = `
                <div class="top">
                    <div class="left">
                        <div class="icon-bg">
                            <div class="inner-icon">
                                <div class="inner-bar"></div>
                            </div>
                        </div>
                        <div class="details">
                            <h3 style="text-transform: capitalize">
                                Deposit
                                <span style="color:${d.status=='pending'?'#c68300ff':(d.status=='approved'?'#00c676':'#ff3b3b')}">
                                    &nbsp;&nbsp;(${d.status})
                                </span>
                            </h3>
                            <p>${d.created_at}</p>
                        </div>
                    </div>
                    <div class="right">
                        <div class="amount">+₦${Number(d.final_amount).toLocaleString()}</div>
                        ${d.amount != d.final_amount ? `<div class="amount secondary">+$${Number(d.amount).toFixed(4)}</div>` : ''}
                    </div>
                </div>
            `;
            container.appendChild(div);
        });
    });
});
</script>
</body>
</html>
