@php
  $user = auth()->user();
  // $amount, $currency, $methods, $usdtRate are injected by controller
@endphp
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title>Choose Payment Method</title>
  <link href="https://cdn.jsdelivr.net/npm/remixicon@3.5.0/fonts/remixicon.css" rel="stylesheet">
  <style>
    /* keep style concise — reuse same CSS as index if you want exact look */
    body{font-family:'Poppins',sans-serif;background:linear-gradient(135deg,#0f2a1a,#036320);color:#fff;padding:18px;}
    .card{background:#fff;border-radius:10px;color:#111;padding:16px;}
    .channel-card{background:#fff;border-radius:6px;padding:8px 10px;display:flex;align-items:center;margin-bottom:12px;cursor:pointer;border:1px solid rgba(0,0,0,0.06);}
    .channel-card .icon{width:40px;height:40px;border-radius:20px;display:flex;align-items:center;justify-content:center;margin-right:12px;color:#fff;}
  </style>
</head>
<body>

  <a href="{{ route('user.recharge') }}" style="color:#fff;display:inline-block;margin-bottom:12px;">← Back</a>

  <div class="card">
    <h3 style="margin-bottom:6px">Confirm top up</h3>
    <p style="margin-bottom:12px">Amount: 
      @if($currency === 'USDT')
        ${{ number_format($amount, 2) }} (≈ ₦{{ number_format($amount * $usdtRate, 2) }})
      @else
        ₦{{ number_format($amount, 2) }}
      @endif
    </p>

    @if($currency === 'NGN')
      <form method="GET" action="{{ url('/user/payment/'.$amount) }}">
        <label style="display:block;margin-bottom:8px;font-weight:600">Select payment method</label>

        <!-- You requested this exact foreach to populate methods -->
        <select name="payment_method" id="payment_method" style="width:100%;padding:10px;border-radius:6px;border:1px solid #ddd;margin-bottom:12px;">
          <option value="">-- Select payment channel --</option>
          @foreach(\App\Models\PaymentMethod::where('status','active')->where('type','ngn')->get() as $el)
            <option value="{{ $el->id }}" data-number="{{ $el->number }}">{{ $el->name }} — {{ $el->number ?? '' }}</option>
          @endforeach
        </select>

        <p style="font-size:13px;color:#555">After selecting a method you will be shown account details and then asked to upload transaction proof.</p>

        <a href="{{ url('user/payment/'.$amount) }}" id="proceedBtn" onclick="return false;" style="display:inline-block;margin-top:12px;padding:12px 18px;background:linear-gradient(90deg,#25eb67,#1eaf2c);color:#fff;border-radius:8px;text-decoration:none;">Proceed</a>
      </form>

      <script>
        // When user clicks Proceed, redirect to payment_confirm route with method id -> we will look up by id server-side.
        document.getElementById('proceedBtn').addEventListener('click', function(){
          const sel = document.getElementById('payment_method');
          const val = sel.value;
          if (!val) { alert('Select payment channel'); return; }

          // Find selected option text (name) to pass to payment_confirm route (your payment_confirm searches by name).
          const opt = sel.options[sel.selectedIndex];
          const text = opt.text || '';
          // We'll redirect to your payment_confirm route (user/payment/{amount}/{method})
          // Note: your controller's payment_confirm finds PaymentMethod::where('name', $payment_method)
          // To be safe, pass the name portion (before dash) if you included dash — here we pass the method name.
          // If you prefer to pass id, change controller.payment_confirm accordingly.
          const methodName = text.split('—')[0].trim();
          window.location.href = '/user/payment/' + encodeURIComponent({{ $amount }}) + '/' + encodeURIComponent(methodName);
        });
      </script>
    @else
      {{-- USDT flow: show USDT methods and a small form to POST to user.usdt.deposit --}}
      <form method="POST" action="{{ route('user.usdt.deposit') }}">
        @csrf
        <input type="hidden" name="usdt_amount" value="{{ $amount }}">
        <label style="display:block;margin-bottom:8px;font-weight:600">Select USDT channel</label>
        <select name="usdt_method" required style="width:100%;padding:10px;border-radius:6px;border:1px solid #ddd;margin-bottom:12px;">
          <option value="">-- Select USDT method --</option>
          @foreach(\App\Models\PaymentMethod::where('status','active')->where('type','usdt')->get() as $el)
            <option value="{{ $el->name }}">{{ $el->name }} {{ $el->number ? ' - ' . $el->number : '' }}</option>
          @endforeach
        </select>

        <p style="font-size:13px;color:#555">USDT amount: ${{ number_format($amount,2) }} — Approx ₦{{ number_format($amount * $usdtRate, 2) }}</p>

        <button type="submit" style="margin-top:12px;padding:12px 18px;background:linear-gradient(90deg,#25eb67,#1eaf2c);color:#fff;border-radius:8px;border:0;">Submit USDT Deposit</button>
      </form>
    @endif
  </div>

</body>
</html>
