@php
  $user = auth()->user();
@endphp
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title>{{ config('app.name') }} | Top Up</title>
  <link rel="icon" href="{{ asset('assets/images/logo.jpg') }}">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  <link href="https://cdn.jsdelivr.net/npm/remixicon@3.5.0/fonts/remixicon.css" rel="stylesheet">

  <style>
    /* same exact CSS you gave me (kept minimal here, copy your full CSS if you prefer) */
    *{margin:0;padding:0;box-sizing:border-box;font-family:'Poppins',sans-serif;}
    body{min-height:100vh;background:linear-gradient(135deg,#0f2a1a,#036320);color:#fff;}
    .app{width:100%;max-width:520px;margin:0 auto;position:relative;}
    .header{display:flex;justify-content:space-between;align-items:center;padding:3rem 1rem 1rem;margin-top:-20px;}
    .header button{width:2rem;height:2rem;background:none;border:none;color:#fff;cursor:pointer;font-size:1.5rem;}
    .topup-container{display:flex;flex-direction:column;}
    .apd-balance{padding:0 16px 24px;position:relative;}
    .apd-balance img{position:absolute;top:0;right:16px;width:100px;}
    .apd-balance .label{color:rgba(255,255,255,0.7);font-size:14px;margin-bottom:4px;}
    .apd-balance .value{font-size:28px;font-weight:700;}
    .apd-toggle{background:rgba(255,255,255,0.2);border-radius:50px;display:flex;padding:4px;margin:0 16px 10px;}
    .apd-toggle button{flex:1;padding:12px 20px;border-radius:50px;border:none;background:none;font-size:14px;font-weight:500;color:#fff;cursor:pointer;transition:.3s;}
    .apd-toggle button.active{background:#fff;color:#0b1d4a;}
    .amount-section{padding:0 16px 5px;}
    .amount-grid{display:flex;flex-wrap:wrap;gap:12px;margin-bottom:16px;}
    .amount-grid button{padding:10px;border-radius:5px;border:2px solid rgba(255,255,255,0.3);background:none;width:30%;color:rgba(255,255,255,0.7);font-size:13px;font-weight:500;cursor:pointer;transition:.3s;}
    .amount-grid button.active{border-color:#5aff48;background:rgba(255,255,255,0.1);color:#fff;}
    .amount-input{background:#fff;border-radius:5px;display:flex;align-items:center;padding:12px 16px;}
    .amount-input span{color:#555;font-size:20px;margin-right:8px;}
    .amount-input input{border:none;outline:none;background:transparent;color:#00741d;font-size:22px;font-weight:700;}
    .channel-section{padding:0 16px 4px;}
    .channel-warning{background:#fff;border-radius:5px;padding:12px 16px;margin-bottom:16px;}
    .channel-warning p{color:#d32f2f;font-size:14px;font-weight:500;margin:0;}
    .channel-card{background:#fff;border-radius:5px;padding:8px 10px;display:flex;align-items:center;margin-bottom:16px;cursor:pointer;border:1px solid rgba(0,0,0,0.06);}
    .channel-card .icon{width:40px;height:40px;border-radius:20px;display:flex;align-items:center;justify-content:center;margin-right:16px;color:#fff;font-size:16px;}
    .info{display:flex;align-items:center;justify-content:space-between;width:100%;}
    .info span{color:#222;font-size:18px;font-weight:700;}
    .continue-btn{background:linear-gradient(to right,#25eb67,#1eaf2c);color:#fff;border:none;width:calc(100% - 32px);margin:0 16px 32px;padding:16px;border-radius:14px;font-size:18px;font-weight:500;cursor:pointer;}
    .continue-btn.disabled{opacity:.5;cursor:not-allowed;}
  </style>
</head>
<body>
  <div class="app">
    <div class="header">
      <button onclick="window.history.back()"><i class="ri-arrow-left-line"></i></button>
      <h1 style="font-size:1.1rem;font-weight:500;">Top Up</h1>
      <button onclick="window.location.href='{{ route('recharge.history.preview') }}'"><i class="ri-history-line"></i></button>
    </div>

    <main>
      <div class="topup-container">
        <form id="depositForm" method="POST" action="javascript:void(0);">
          @csrf
          <input type="hidden" id="chosenCurrency" value="NGN">
          <input type="hidden" id="chosenAmount" value="5000">

          <div class="apd-balance">
            <img src="{{ asset('assets/images/dep.png') }}" class="green-filter">
            <p class="label">Balance</p>
            <p class="value">{{ $user->currency_symbol ?? '₦' }}{{ number_format($user->balance ?? 0, 2) }}</p>
          </div>

          <!-- Currency Buttons -->
          <div class="apd-toggle" role="tablist" aria-label="Payment method">
            <button type="button" id="btnNGN" class="active" onclick="switchCurrency('NGN')">Currency Payment</button>
            <button type="button" id="btnUSDT" onclick="switchCurrency('USDT')">USDT Payment</button>
          </div>

          <!-- Amount Section -->
          <div class="amount-section">
            <h3>Top up amount</h3>
            <div id="amountGridNGN" class="amount-grid">
              <button type="button" data-amount="5000">₦5,000</button>
              <button type="button" data-amount="10000">₦10,000</button>
              <button type="button" data-amount="20000">₦20,000</button>
              <button type="button" data-amount="50000">₦50,000</button>
            </div>

            <div id="amountGridUSDT" class="amount-grid" style="display:none;">
              <button type="button" data-amount="20">$20</button>
              <button type="button" data-amount="50">$50</button>
              <button type="button" data-amount="100">$100</button>
              <button type="button" data-amount="200">$200</button>
            </div>

            <div class="amount-input">
              <span id="currencySymbol">₦</span>
              <input type="number" id="customAmount" value="5000" min="0" aria-label="Custom amount">
            </div>

            <div id="ngnEquivalent" style="font-size:13px;margin-top:8px;text-align:right;color:rgba(255,255,255,0.85);display:none;"></div>
          </div>

          <!-- Channel Section (buttons will be rendered on the next page where server lists PaymentMethod) -->
          <div class="channel-section">
            <h3>Top up channel</h3>
            <div id="channelWarning" class="channel-warning"><p>Please note: Opay transfer may be delayed.</p></div>

            <div id="channelCards">
              <!-- For the index page we show generic placeholders; actual method selection happens on /user/payment/{amount} -->
              <div class="channel-card">
                <div class="icon" style="background:linear-gradient(to right,#facc15,#fb923c);"><i class="ri-bank-fill"></i></div>
                <div class="info"><span>Choose a channel after Continue</span></div>
              </div>
            </div>
          </div>

          <button type="button" id="continueBtn" class="continue-btn disabled" onclick="onContinueClick()">Continue</button>
        </form>
      </div>
    </main>
  </div>

<script>
  // Client-side logic (keeps your design exactly)
  let currentCurrency = 'NGN';
  let selectedAmount = 5000;

  const btnNGN = document.getElementById('btnNGN');
  const btnUSDT = document.getElementById('btnUSDT');
  const amountGridNGN = document.getElementById('amountGridNGN');
  const amountGridUSDT = document.getElementById('amountGridUSDT');
  const continueBtn = document.getElementById('continueBtn');
  const customAmount = document.getElementById('customAmount');
  const currencySymbol = document.getElementById('currencySymbol');
  const ngnEquivalent = document.getElementById('ngnEquivalent');

  // server-provided rate (used on index only for preview). If you want server value, inject it as a JS var
  const USDT_RATE = {{ config('services.usdt_rate', 1460) }};

  function switchCurrency(cur){
    currentCurrency = cur;
    document.getElementById('chosenCurrency').value = cur;
    amountGridNGN.style.display = cur === 'NGN' ? 'flex' : 'none';
    amountGridUSDT.style.display = cur === 'USDT' ? 'flex' : 'none';
    document.getElementById('channelWarning').style.display = cur === 'NGN' ? 'block' : 'none';
    currencySymbol.textContent = cur === 'NGN' ? '₦' : '$';
    btnNGN.classList.toggle('active', cur === 'NGN');
    btnUSDT.classList.toggle('active', cur === 'USDT');

    // update ngnEquivalent visibility for USDT
    ngnEquivalent.style.display = cur === 'USDT' ? 'block' : 'none';
    updateNgNEquivalent();
    enableContinue();
  }

  // preset button clicks
  document.querySelectorAll('#amountGridNGN button, #amountGridUSDT button').forEach(btn=>{
    btn.addEventListener('click', function(){
      document.querySelectorAll('.amount-grid button').forEach(b=>b.classList.remove('active'));
      this.classList.add('active');
      selectedAmount = Number(this.dataset.amount);
      customAmount.value = selectedAmount;
      updateNgNEquivalent();
      enableContinue();
    });
  });

  customAmount.addEventListener('input', function(){
    selectedAmount = Number(this.value) || 0;
    document.querySelectorAll('.amount-grid button').forEach(b=>b.classList.remove('active'));
    updateNgNEquivalent();
    enableContinue();
  });

  function updateNgNEquivalent(){
    if (currentCurrency === 'USDT') {
      const naira = (Number(selectedAmount) || 0) * Number(USDT_RATE);
      ngnEquivalent.innerHTML = `<strong style="font-size:13px">≈ ₦${Number(naira).toLocaleString('en-NG', {minimumFractionDigits:2, maximumFractionDigits:2})}</strong><br><span style="font-size:11px">1 USDT = ₦${Number(USDT_RATE).toLocaleString('en-NG')}</span>`;
    } else {
      ngnEquivalent.innerHTML = '';
    }
  }

  function enableContinue(){
    if ((Number(selectedAmount) > 0)) {
      continueBtn.classList.remove('disabled');
    } else {
      continueBtn.classList.add('disabled');
    }
  }

  function onContinueClick(){
    if (continueBtn.classList.contains('disabled')) return;

    const amount = Number(customAmount.value) || selectedAmount || 0;
    if (!amount || amount <= 0) {
      alert('Enter a valid amount');
      return;
    }

    if (currentCurrency === 'NGN') {
      // go to your existing route: /user/payment/{amount}
      window.location.href = '/user/payment/' + encodeURIComponent(amount);
      return;
    }

    // USDT: go to same controller route but add a query param so controller can render USDT UI
    // e.g. /user/payment/20?currency=USDT
    window.location.href = '/user/payment/' + encodeURIComponent(amount) + '?currency=USDT';
  }

  // init
  switchCurrency('NGN');
  enableContinue();
</script>
</body>
</html>
