@extends('app.layout.app')

@section('header_content')
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600;800&display=swap" rel="stylesheet">
    <style>
        /* Base Background */
        body { 
            background-color: #0b0d0c !important; 
            background-image: url('https://www.transparenttextures.com/patterns/circuit-board.png'); 
            font-family: 'Poppins', sans-serif;
            color: #fff;
        }
        .wrapper-inline { background-color: transparent !important; }
        
        /* Balance Header Section */
        .badger { margin-top: 10px; }
        .header_box_card { 
            background: rgba(255, 255, 255, 0.05); 
            border: 1px solid #333; 
            border-radius: 15px;
        }
        .my-balance { color: #39ff14; font-weight: 800; }

        /* Modern Purchase Card */
        .vip_cards_box { padding: 20px 0; }
        .purchase-card { 
            background: #141615; 
            border-radius: 24px; 
            overflow: hidden; 
            border: 1px solid #2d2d2d;
            box-shadow: 0 20px 40px rgba(0,0,0,0.6);
            max-width: 480px;
            margin: 0 auto;
        }

        /* Neon Image Box */
        .img-container { padding: 15px; position: relative; }
        .product-img {
            width: 100%;
            border-radius: 18px;
            border: 2px solid #39ff14;
            box-shadow: 0 0 20px rgba(57, 255, 20, 0.2);
        }
        .close-btn {
            position: absolute; top: 25px; right: 30px;
            background: rgba(0,0,0,0.6); color: #fff;
            width: 35px; height: 35px; border-radius: 50%;
            display: flex; align-items: center; justify-content: center;
            text-decoration: none; font-weight: bold; z-index: 5;
        }

        /* Product Info */
        .product-info { padding: 0 20px 25px 20px; }
        .product-name { font-size: 30px; font-weight: 800; margin-bottom: 2px; color: #fff; }
        .product-title { color: #aaa; font-size: 14px; margin-bottom: 15px; }

        /* Information Table style box */
        .info-box {
            background: rgba(255, 255, 255, 0.03);
            border: 1px solid #333;
            border-radius: 14px;
            padding: 15px;
            margin-bottom: 15px;
        }
        .info-title { color: #39ff14; font-weight: 600; margin-bottom: 10px; }
        .info-row { display: flex; justify-content: space-between; margin-bottom: 6px; font-size: 14px; }
        .val-green { color: #39ff14; font-weight: bold; }
        .val-red { color: #ff3131; font-weight: bold; }

        /* Invitation Bonus (Neon Dashed) */
        .bonus-box {
            border: 2px dashed #39ff14;
            background: rgba(57, 255, 20, 0.08);
            border-radius: 18px;
            padding: 15px;
            text-align: center;
            margin-bottom: 25px;
        }
        .bonus-label { font-size: 16px; color: #fff; margin-bottom: 5px; }
        .bonus-amount { font-size: 36px; font-weight: 900; color: #39ff14; display: block; }

        /* Buy Button Gradient */
        .buy-btn {
            background: linear-gradient(90deg, #1dbb61 0%, #30b1d3 100%);
            border: none; color: white; width: 100%;
            padding: 16px; border-radius: 12px;
            font-size: 18px; font-weight: 700;
            display: block; text-align: center;
            text-decoration: none; transition: 0.3s;
        }
        .buy-btn:hover { transform: scale(1.02); color: #fff; }
        
        /* Disabled Button Style */
        .btn-disabled {
            background: #444 !important;
            color: #888 !important;
            cursor: not-allowed;
            transform: none !important;
        }

        footer { display: none; }
    </style>
@endsection

@section('app_content')
    @include('app.layout.header')

    @php
        // Check current purchase count for this package
        $usedLimit = \App\Models\Purchase::where('user_id', auth()->id())->where('package_id', $vip->id)->count();
        $isLimitReached = ($vip->purchase_limit > 0 && $usedLimit >= $vip->purchase_limit);
    @endphp

    <section class="badger">
        <div class="container">
            <div class="card header_box_card">
                <div class="card-body header_box">
                    <div class="row align-items-center">
                        <div class="col-6">
                            <small style="color: #aaa;">Your Balance</small>
                            <h3 class="my-balance">{{price(auth()->user()->balance)}}</h3>
                        </div>
                        <div class="col-6 text-right">
                            <h4 style="color: #fff; font-size: 14px;">Product Details</h4>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="vip_cards_box">
        <div class="container">
            <div class="purchase-card">
                
                <div class="img-container">
                    <a href="{{ url()->previous() }}" class="close-btn">X</a>
                    <img src="{{ view_image($vip->photo) }}" class="product-img" alt="Product">
                </div>

                <div class="product-info">
                    <h1 class="product-name">{{ $vip->name }}</h1>
                    <p class="product-title">{{ $vip->title }}</p>

                    <div class="info-box">
                        <div class="info-title">Information</div>
                        <div class="info-row">
                            <span>Price:</span>
                            <span>{{ price($vip->price) }}</span>
                        </div>
                        <div class="info-row">
                            <span>Daily income:</span>
                            <span class="val-green">{{ price($vip->commission_with_avg_amount / $vip->validity) }}</span>
                        </div>
                        <div class="info-row">
                            <span>Duration:</span>
                            <span>{{ $vip->validity }} Days</span>
                        </div>
                        
                        {{-- PURCHASE LIMIT ROW --}}
                        <div class="info-row" style="margin-top: 10px; padding-top: 10px; border-top: 1px solid rgba(255,255,255,0.1);">
                            <span>Purchase Limit:</span>
                            <span class="{{ $isLimitReached ? 'val-red' : 'val-green' }}">
                                @if($vip->purchase_limit > 0)
                                    {{ $usedLimit }} / {{ $vip->purchase_limit }} Times
                                @else
                                    Unlimited
                                @endif
                            </span>
                        </div>
                    </div>

                    @if($vip->referral_bonus > 0)
                    <div class="bonus-box">
                        <div class="bonus-label">
                            <i class="fa fa-gift"></i> Invitation Bonus
                        </div>
                        <span class="bonus-amount">{{ price($vip->referral_bonus) }}</span>
                    </div>
                    @endif

                    @if($isLimitReached)
                        <a href="javascript:void(0)" class="buy-btn btn-disabled">
                            Limit Reached
                        </a>
                        <p style="color: #ff3131; text-align: center; font-size: 12px; margin-top: 8px;">*You have reached the maximum purchase limit for this plan.</p>
                    @else
                        <a href="{{ route('purchase.confirmation', $vip->id) }}" class="buy-btn">
                            {{ price($vip->price) }} Buy Now
                        </a>
                    @endif
                </div>
            </div>
        </div>
    </section>
@endsection
