@extends('app.layout.app')
@section('app_content')
    <div class="container">
        <div class="menu">
            <ul>
                <li><a href="{{route('user.mining')}}" id="active">Less</a></li>
                <li><a href="{{route('user.mining.my')}}">Purchase</a></li>
            </ul>
        </div>

        <div class="all-items">
            @foreach(\App\Models\Package::where('status', 'active')->get() as $key=>$element)
                @php
                    // Check how many times user has bought THIS specific package
                    $myCount = \App\Models\Purchase::where('user_id', auth()->id())
                                ->where('package_id', $element->id)
                                ->where('status', 'active')
                                ->count();
                    
                    // Logic: Button tabhi disabled hoga jab limit poori ho chuki ho
                    $isLimitFull = ($element->purchase_limit > 0 && $myCount >= $element->purchase_limit);
                @endphp

                <div class="items" style="width:100%">
                    <div class="product-img">
                        <img style="border-radius: 6px;" src="{{asset($element->photo)}}" alt="">
                    </div>

                    <div class="product-text">
                        <h2>{{$element->name}}</h2>
                        <p>Valid Period: {{$element->validity}} days</p>
                        <p>Settlement currency: BDT(৳)</p>
                        <p>Daily income: {{price($element->commission_with_avg_amount / $element->validity)}}</p>
                        <p>Total revenue: {{price($element->commission_with_avg_amount)}}</p>
                        
                        <p style="color: #ff9800; font-weight: bold;">
                            Limit: {{$myCount}} / {{$element->purchase_limit > 0 ? $element->purchase_limit : 'Unlimited'}}
                        </p>

                        <div class="item-rent">
                            <h3>{{price($element->price)}}</h3>
                            
                            @if($isLimitFull)
                                <button type="button" style="background: #ccc; color: #666; cursor: not-allowed;">Limit Full</button>
                            @else
                                <button type="button" onclick="openPopPurchase('package{{$element->id}}')">RENT</button>
                            @endif
                        </div>
                    </div>
                </div>

                <div class="pop_purchase" id="package{{$element->id}}" style="display: none">
                    <div class="pop_container_purchase">
                        <h3>Tips</h3>
                        <p>Are you sure you want to buy <strong>{{$element->name}}</strong>?</p>

                        <div class="purchase_btns">
                            <button style="color: red;" onclick="closePopPurchase('package{{$element->id}}')">Cancel</button>
                            <button style="color: green;" onclick="window.location.href='{{route('purchase.confirmation', $element->id)}}'">OK</button>
                            <div class="h_border"></div>
                        </div>
                    </div>
                </div>
            @endforeach
        </div>
    </div>
    <div style="height: 120px;"></div>

    <script>
        function closePopPurchase(id){
            document.getElementById(id).style.display='none';
        }
        function openPopPurchase(id){
            document.getElementById(id).style.display='block';
        }
    </script>
@endsection
