@php
use App\Models\UserLedger;

// Get all records for current user
$records = UserLedger::where('user_id', auth()->id())
    ->orderByDesc('id')
    ->take(20)
    ->get();
@endphp

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width,initial-scale=1">
<title>GTX | Transaction Records</title>
<link rel="icon" type="image/png" href="/assets/images/logo.jpg">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
<link href="https://cdn.jsdelivr.net/npm/remixicon@3.5.0/fonts/remixicon.css" rel="stylesheet">

<style>
*{margin:0;padding:0;box-sizing:border-box;font-family:'Poppins',sans-serif;}
body{min-height:100vh;background:linear-gradient(135deg,#0f2a1a,#036320);color:white;overflow-x:hidden;}
.app{width:100%;max-width:520px;margin:0 auto;}
.green-filter{filter:hue-rotate(260deg) saturate(150%);}
.tabs{margin:10px 16px 24px;background:rgba(255,255,255,0.1);border-radius:9999px;padding:4px;display:grid;grid-template-columns:repeat(3,1fr);gap:4px;}
.tab{padding:10px;border-radius:9999px;font-size:14px;font-weight:500;cursor:pointer;transition:0.3s;text-align:center;}
.tab.active{background:white;color:#0f6805;}
.tab.inactive{color:rgba(255,255,255,0.7);}
.transactions{padding:0 16px 10px;}
.transaction{border-radius:16px;padding:16px;margin-bottom:12px;background:rgba(255,255,255,0.05);}
.transaction .top{display:flex;justify-content:space-between;align-items:center;}
.left{display:flex;align-items:center;gap:12px;}
.icon-bg{width:40px;height:40px;background:rgba(255,255,255,0.2);border-radius:50%;display:flex;align-items:center;justify-content:center;}
.inner-icon{width:20px;height:20px;background:white;border-radius:6px;display:flex;align-items:center;justify-content:center;}
.inner-bar{width:10px;height:16px;background:#18a009;border-radius:4px;}
.details h3{font-size:14px;font-weight:500;margin:0;}
.details p{font-size:10px;color:rgba(255,255,255,0.7);margin:2px 0 0;}
.amount{font-size:15px;font-weight:600;}
.empty{text-align:center;color:rgba(255,255,255,0.6);margin-top:60px;font-size:15px;}
.empty img{width:150px;margin-bottom:12px;}
.load-more{display:flex;justify-content:center;margin-top:5px;margin-bottom:50px;}
.load-more button{padding:10px 14px;border-radius:10px;font-weight:700;cursor:pointer;border:0;background:white;color:#2563eb;}
@media (max-width:600px){.transaction{padding:14px;}.amount{font-size:13px;}}
</style>
</head>
<body>
<div class="app">

<!-- Header -->
<div class="header" style="display:flex;justify-content:space-between;align-items:center;padding:3rem 1rem 1rem;margin-top:-20px;">
  <button onclick="window.history.back()" style="width:2rem;height:2rem;background:none;border:none;color:#fff;font-size:1.5rem;"><i class="ri-arrow-left-line"></i></button>
  <h1 style="font-size:1.1rem;font-weight:500;">Transaction Records</h1>
  <div style="width:2rem;height:2rem;"></div>
</div>

<!-- Tabs -->
<div class="tabs">
  <div class="tab active" data-tab="all">All</div>
  <div class="tab inactive" data-tab="credit">Credit</div>
  <div class="tab inactive" data-tab="debit">Debit</div>
</div>

<!-- Transactions -->
<div class="transactions" id="transactionsContainer">

  @if($records->isEmpty())
    <div class="empty" data-empty-for="all">
      <img src="/assets/images/no1.png" class="green-filter" alt="No transactions">
      <p>No transactions found</p>
    </div>
  @endif

  @foreach($records as $r)
    @php
        $type = strtolower($r->type ?? 'debit'); // use type field directly
        $symbol = ($type == 'credit') ? '+' : '-';
        $color = ($type == 'credit') ? '#18a009' : '#e83f36';
        $amount = number_format($r->amount, 2);
        $desc = ucfirst(str_replace('_',' ', $r->reason));
        $date = $r->date ?? $r->created_at->format('m/d/Y H:i:s');
    @endphp
    <div class="transaction" data-type="{{ $type }}">
      <div class="top">
        <div class="left">
          <div class="icon-bg">
            <div class="inner-icon"><div class="inner-bar" style="background:{{ $color }}"></div></div>
          </div>
          <div class="details">
            <h3>{{ $desc }}</h3>
            <p>{{ $date }}</p>
          </div>
        </div>
        <div class="amount" style="color:{{ $color }}">{{ $symbol }}{{ setting('currency') }}{{ $amount }}</div>
      </div>
    </div>
  @endforeach

  <!-- Empty placeholders for credit and debit tabs -->
  <div class="empty" data-empty-for="credit" style="display:none;">
    <img src="/assets/images/no1.png" class="green-filter" alt="No credit transactions">
    <p>No credit transactions</p>
  </div>
  <div class="empty" data-empty-for="debit" style="display:none;">
    <img src="/assets/images/no1.png" class="green-filter" alt="No debit transactions">
    <p>No debit transactions</p>
  </div>

</div>
</div>

<script>
document.addEventListener("DOMContentLoaded", function() {
  const tabs = document.querySelectorAll('.tab');
  const allTrans = document.querySelectorAll('.transaction');
  const empties = document.querySelectorAll('.empty');

  function updateVisibility(tabType) {
    let anyVisible = false;

    allTrans.forEach(tr => {
      const dType = tr.dataset.type.toLowerCase();
      if(tabType === 'all' || tabType === dType){
        tr.style.display = 'block';
        anyVisible = true;
      } else {
        tr.style.display = 'none';
      }
    });

    // Show empty for current tab if no records
    empties.forEach(e => {
      if(e.dataset.emptyFor === tabType){
        e.style.display = anyVisible ? 'none' : 'block';
      } else {
        e.style.display = 'none';
      }
    });
  }

  tabs.forEach(tab => {
    tab.addEventListener('click', () => {
      tabs.forEach(t => { t.classList.remove('active'); t.classList.add('inactive'); });
      tab.classList.add('active'); tab.classList.remove('inactive');

      updateVisibility(tab.dataset.tab.toLowerCase());
    });
  });

  // Initial visibility
  updateVisibility('all');
});
</script>
</body>
</html>
