<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width,initial-scale=1">
<title>GTX | Add Bank Details</title>

<meta name="csrf-token" content="{{ csrf_token() }}">
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600&display=swap" rel="stylesheet">

<style>
* { margin:0; padding:0; box-sizing:border-box; font-family:'Poppins',sans-serif; }

body {
  min-height:100vh;
  background:linear-gradient(135deg,#0f2a1a,#036320);
  color:#fff;
  display:flex;
  justify-content:center;
  align-items:center;
  padding:20px;
}

.card {
  width:100%;
  max-width:420px;
  background:rgba(255,255,255,0.12);
  border-radius:15px;
  padding:25px;
  box-shadow: 0 10px 30px rgba(0,0,0,0.4);
  backdrop-filter: blur(10px);
}

h2 {
  text-align:center;
  font-weight:600;
  margin-bottom:25px;
  letter-spacing: 1px;
}

/* Sabhi input rows ko ek jaisa size diya gaya hai */
.input-row {
  display:flex;
  align-items:center;
  background: rgba(255,255,255,0.05);
  border: 1px solid rgba(255,255,255,0.2);
  border-radius: 10px;
  padding: 10px 15px;
  margin-bottom: 15px;
  width: 100%;
}

.prefix {
  margin-right:10px;
  color: #39ff14;
  font-weight: bold;
}

input {
  flex:1;
  background:transparent;
  border:0;
  outline:none;
  color:#fff;
  font-size:15px;
  width: 100%;
}

input::placeholder {
  color:rgba(255,255,255,0.5);
}

/* OTP Wrapper styling */
.otp-container {
    display: flex;
    gap: 10px;
    margin-bottom: 15px;
}

.otp-input-field {
    flex: 1; /* Input box ko stretch karega */
}

.send-otp {
  border:0;
  border-radius:10px;
  padding:0 15px;
  font-size:13px;
  font-weight:600;
  cursor:pointer;
  background: linear-gradient(180deg,#39ff14,#008a2c);
  color:#000;
  white-space: nowrap;
  transition:all 0.3s ease;
  min-width: 100px;
}

.send-otp:hover:not(:disabled) {
  opacity: 0.9;
  transform: translateY(-1px);
}

.send-otp:disabled {
  background: #555;
  color: #ccc;
  cursor:not-allowed;
}

.btn {
  width:100%;
  margin-top:10px;
  padding:14px;
  border:0;
  border-radius:10px;
  background: linear-gradient(90deg, #1dbb61 0%, #30b1d3 100%);
  color:#fff;
  font-size:16px;
  font-weight: bold;
  cursor:pointer;
  transition:all 0.3s ease;
}

.btn:hover:not(:disabled) {
  box-shadow: 0 5px 15px rgba(29, 187, 97, 0.4);
}

.btn:disabled {
  background: #444;
  opacity:0.6;
}
</style>
</head>

<body>

<div class="card">
  <h2>Add Bank Details</h2>

  <form method="POST" action="{{ route('setup.gateway.submit') }}" id="bankForm">
    @csrf
    @include('alert-message')

    <div class="input-row">
      <span class="prefix">+91</span>
      <input type="tel" id="mobile" name="mobile" value="{{ auth()->user()->phone }}" readonly style="cursor: not-allowed;">
    </div>

    <div class="input-row">
      <input type="text" name="realname" placeholder="Account Holder Name" required>
    </div>

    <div class="input-row">
      <input type="text" name="gateway_method" placeholder="Bank Name" required>
    </div>

    <div class="input-row">
      <input type="text" name="gateway_number" placeholder="Account Number" required>
    </div>

    <div class="input-row">
      <input type="text" name="ifsc" placeholder="IFSC Code" maxlength="11" style="text-transform:uppercase" required>
    </div>

    <div class="otp-container">
        <div class="input-row otp-input-field" style="margin-bottom:0;">
            <input type="number" id="otp" name="otp" placeholder="Enter OTP" required>
        </div>
        <button type="button" class="send-otp" id="sendOtpBtn">Send OTP</button>
    </div>

    <button type="submit" class="btn" id="saveBtn" disabled>Save Details</button>
  </form>
</div>

<script>
const mobile = document.getElementById('mobile');
const otp = document.getElementById('otp');
const saveBtn = document.getElementById('saveBtn');
const sendOtpBtn = document.getElementById('sendOtpBtn');

// Timer function
let timer;
function startTimer(duration) {
    let timeLeft = duration;
    sendOtpBtn.disabled = true;
    timer = setInterval(() => {
        if (timeLeft <= 0) {
            clearInterval(timer);
            sendOtpBtn.innerText = "Resend OTP";
            sendOtpBtn.disabled = false;
        } else {
            sendOtpBtn.innerText = timeLeft + "s";
            timeLeft--;
        }
    }, 1000);
}

function toggleSave() {
  saveBtn.disabled = !(mobile.value.trim().length >= 10 && otp.value.trim().length >= 4);
}

mobile.addEventListener('input', toggleSave);
otp.addEventListener('input', toggleSave);

sendOtpBtn.addEventListener('click', () => {
  const phone = mobile.value.trim();
  if(!phone || phone.length < 10) {
    alert('Please enter a valid mobile number');
    return;
  }

  sendOtpBtn.disabled = true;
  sendOtpBtn.innerText = 'Sending...';

  fetch('{{ url("send-otp") }}', {
    method: 'POST',
    headers: {
      'Content-Type': 'application/json',
      'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
    },
    body: JSON.stringify({ phone: phone })
  })
  .then(res => res.json())
  .then(data => {
    if(data.success) {
        alert('OTP Sent successfully!');
        startTimer(60); // 60 seconds timer
    } else {
        alert(data.message || 'Failed to send OTP');
        sendOtpBtn.disabled = false;
        sendOtpBtn.innerText = 'Send OTP';
    }
  })
  .catch(() => {
    alert('Error connecting to server');
    sendOtpBtn.disabled = false;
    sendOtpBtn.innerText = 'Send OTP';
  });
});
</script>

</body>
</html>
