@extends('admin.partials.master')
@section('admin_content')
<section id="dashboard-ecommerce">
    <div class="row">
        <div class="col-sm-12">
            <div class="card">
                <div class="card-header pb-0">
                    <h4 class="card-title">
                        <div class="d-flex justify-content-between">
                            <div>Customer Task Requests</div>
                            <div>
                                <a href="{{ route('admin.search.user') }}" class="btn btn-success">
                                    <i class="bx bx-user"></i> Search A User
                                </a>
                            </div>
                        </div>
                    </h4>
                </div>
                <div class="card-content">
                    <div class="card-body card-dashboard">
                        <div class="table-responsive">
                            <table class="table table-striped dataex-html5-selectors">
                                <thead>
                                    <tr>
                                        <th>S.N</th>
                                        <th>User</th>
                                        <th>Task Level</th>
                                        <th>Required Invites</th>
                                        <th>Min Purchase (NGN)</th>
                                        <th>Progress</th>
                                        <th>Bonus (NGN)</th>
                                        <th>Extra Profit (%)</th>
                                        <th>Status</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach(\App\Models\TaskRequest::with(['task', 'user'])->orderByDesc('id')->get() as $key => $row)
                                        @if($row->task && $row->user)
                                            <tr>
                                                <td>{{ $key + 1 }}</td>
                                                <td>{{ $row->user->name ?? $row->user->ref_id }}</td>
                                                <td>{{ $row->task->level }}</td>
                                                <td>{{ $row->task->required_invites }}</td>
                                                <td>{{ number_format($row->task->required_purchase, 2) }}</td>
                                                <td>{{ $row->progress ?? 0 }}/{{ $row->task->required_invites }}</td>
                                                <td>{{ number_format($row->task->bonus, 2) }}</td>
                                                <td>{{ $row->task->extra_profit }}</td>
                                                <td>
                                                    @if($row->status == 'approved')
                                                        <span class="badge badge-success">{{ $row->status }}</span>
                                                    @elseif($row->status == 'rejected')
                                                        <span class="badge badge-danger">{{ $row->status }}</span>
                                                    @else
                                                        <span class="badge badge-warning">{{ $row->status }}</span>
                                                    @endif
                                                </td>
                                            </tr>
                                        @endif
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>   
        </div>
    </div>
</section>
@endsection
