@extends('admin.partials.master')
@section('admin_content')
<section id="dashboard-ecommerce">
    <div class="row">
        <div class="col-12">
            <form action="{{ route('admin.task.insert') }}" method="POST" enctype="multipart/form-data">@csrf
                <input type="hidden" name="id" value="{{ $data ? $data->id : '' }}">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">
                            <div class="d-flex justify-content-between">
                                <div>{{ $data ? 'Update' : 'Create New' }} Task</div>
                                <div>
                                    <a href="{{ route('admin.task.index') }}" class="btn btn-primary btn-sm">
                                        <i class="bx bx-left-arrow"></i> Task List
                                    </a>
                                </div>
                            </div>
                        </h4>
                    </div>
                    <div class="card-content">
                        <div class="card-body">
                            <div class="row">

                                <div class="col-sm-6">
                                    <label for="level">Level</label>
                                    <input type="number" class="form-control is-valid"
                                           name="level" id="level"
                                           placeholder="Task Level" value="{{ $data ? $data->level : '' }}" required>
                                    <div class="valid-feedback">
                                        <i class="bx bx-radio-circle"></i> This field is required
                                    </div>
                                </div>

                                <div class="col-sm-6">
                                    <label for="required_invites">Required Invites</label>
                                    <input type="number" class="form-control is-valid"
                                           name="required_invites" id="required_invites"
                                           placeholder="Number of A-grade subordinates" value="{{ $data ? $data->required_invites : '' }}" required>
                                    <div class="valid-feedback">
                                        <i class="bx bx-radio-circle"></i> This field is required
                                    </div>
                                </div>

                                <div class="col-sm-6 mt-2">
                                    <label for="required_purchase">Minimum Purchase (NGN)</label>
                                    <input type="number" class="form-control is-valid"
                                           name="required_purchase" id="required_purchase"
                                           placeholder="Minimum purchase per subordinate" value="{{ $data ? $data->required_purchase : '' }}" required>
                                    <div class="valid-feedback">
                                        <i class="bx bx-radio-circle"></i> This field is required
                                    </div>
                                </div>

                                <div class="col-sm-6 mt-2">
                                    <label for="bonus">Monthly Bonus (NGN)</label>
                                    <input type="number" class="form-control is-valid"
                                           name="bonus" id="bonus"
                                           placeholder="Bonus" value="{{ $data ? $data->bonus : '' }}" required>
                                    <div class="valid-feedback">
                                        <i class="bx bx-radio-circle"></i> This field is required
                                    </div>
                                </div>

                                <div class="col-sm-6 mt-2">
                                    <label for="extra_profit">Extra Profit (%)</label>
                                    <input type="number" step="0.01" class="form-control is-valid"
                                           name="extra_profit" id="extra_profit"
                                           placeholder="Extra profit %" value="{{ $data ? $data->extra_profit : '' }}" required>
                                    <div class="valid-feedback">
                                        <i class="bx bx-radio-circle"></i> This field is required
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>

                <!-- Form Submit Button -->
                <div class="card mt-2">
                    <div class="card-header">
                        <h6 class="card-title">
                            <div class="d-flex justify-content-between">
                                <div style="margin-top: .7rem !important">Submit Task Information</div>
                                <div>
                                    <div class="form-group mb-0">
                                        <button type="submit" class="btn btn-success">
                                            <i class="bx bx-plus"></i> {{ $data ? 'Update' : 'Submit' }}
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </h6>
                    </div>
                </div>
            </form>
        </div>
    </div>
</section>
@endsection
