@extends('admin.partials.master')
@section('admin_content')
<section id="dashboard-ecommerce">
    <div class="row">
        <div class="col-sm-12">
            <div class="card">
                <div class="card-header pb-0">
                    <h4 class="card-title">
                        <div class="d-flex justify-content-between">
                            <div>Task Lists</div>
                            <div>
                                <a href="{{ route('admin.task.create') }}" class="btn btn-primary btn-sm">
                                    <i class="bx bx-plus"></i> Add New Task
                                </a>
                            </div>
                        </div>
                    </h4>
                </div>
                <div class="card-content">
                    <div class="card-body card-dashboard">
                        <div class="table-responsive">
                            <table class="table table-striped dataex-html5-selectors">
                                <thead>
                                    <tr>
                                        <th>S.N</th>
                                        <th>Level</th>
                                        <th>Required Invites</th>
                                        <th>Min Purchase (NGN)</th>
                                        <th>Progress</th>
                                        <th>Bonus (NGN)</th>
                                        <th>Extra Profit (%)</th>
                                        <th>Status</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($tasks as $key => $task)
                                    <tr>
                                        <td>{{ $key + 1 }}</td>
                                        <td>{{ $task->level }}</td>
                                        <td>{{ $task->required_invites }}</td>
                                        <td>{{ number_format($task->required_purchase, 2) }}</td>
                                        <td>{{ $task->progress }}/{{ $task->required_invites }}</td>
                                        <td>{{ number_format($task->bonus, 2) }}</td>
                                        <td>{{ $task->extra_profit }}</td>
                                        <td>
                                            @if($task->status == 'Eligible')
                                                <span class="badge badge-success">{{ $task->status }}</span>
                                            @elseif($task->status == 'Completed')
                                                <span class="badge badge-primary">{{ $task->status }}</span>
                                            @else
                                                <span class="badge badge-warning">{{ $task->status }}</span>
                                            @endif
                                        </td>
                                        <td>
                                            <a href="{{ route('admin.task.create', $task->id) }}"
                                               class="btn btn-warning btn-sm" style="padding: 3px 7px; font-size: 16px" data-toggle="tooltip" title="Edit">
                                                <i class="bx bx-pencil"></i>
                                            </a>
                                            <form method="POST" action="{{ route('admin.task.delete', $task->id) }}" class="d-inline">
                                                @csrf
                                                {{ method_field('DELETE') }}
                                                <button type="submit" class="btn btn-danger btn-sm" style="padding: 3px 7px; font-size: 16px" data-toggle="tooltip" title="Delete">
                                                    <i class="bx bx-trash"></i>
                                                </button>
                                                @include('admin.partials.delete-confirmation')
                                            </form>
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>   
        </div>
    </div>
</section>
@endsection
