@extends('admin.partials.master')
@section('admin_content')
    <section id="dashboard-ecommerce">
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-header pb-0">
                        <h4 class="card-title">
                            <div class="d-flex justify-content-between">
                                <div>{{$title}} Payment Lists</div>
                            </div>
                        </h4>
                    </div>
                    <div class="card-content">
                        <div class="card-body card-dashboard">
                            <div class="table-responsive">
                                <table class="table table-striped dataex-html5-selectors">
                                    <thead>
                                    <tr>
                                        <th>S.N</th>
                                        <th>User</th>
                                        <th>OPTR</th>
                                        <th>TRX</th>
                                        <th>Amounts</th>
                                        <th>Photo</th>
                                        <th>Status</th>
                                        <th>Active</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @foreach($payments as $key => $row)
                                        <tr>
                                            <td>{{$key + 1}}</td>
                                            <td>
                                                {{-- Check if user exists to prevent "phone on null" error --}}
                                                @if($row->user)
                                                    <form action="{{route('admin.search.submit')}}" method="get">
                                                        @csrf
                                                        <input type="hidden" id="search" name="search" class="form-control is-valid" value="{{$row->user->phone}}">
                                                        <input type="submit" class="btn btn-sm btn-link" value="{{$row->user->phone}}">
                                                    </form>
                                                @else
                                                    <span class="text-danger">User Deleted</span>
                                                @endif
                                            </td>
                                            <td>{{$row->method_name}}</td>
                                            <td>{{$row->transaction_id}}</td>
                                            <td>{{price($row->final_amount)}}</td>
                                            <td>
                                                <a href="{{asset($row->photo)}}" target="_blank">
                                                    <img src="{{asset($row->photo)}}" style="width: 100px; height: 100px; object-fit: cover;" alt="Payment Proof">
                                                </a>
                                            </td>
                                            <td>
                                                <span class="badge @if($row->status == 'pending') badge-warning @elseif($row->status == 'approved') badge-success @elseif($row->status == 'rejected') badge-danger @endif" style="font-size: 10px">
                                                    {{strtoupper($row->status)}}
                                                </span>
                                            </td>
                                            <td>
                                                <div class="btn-group" role="group">
                                                    @if($row->status == 'pending')
                                                        <a href="javascript:void(0)" data-toggle="modal" data-target="#myModal{{$row->id}}" class="btn btn-success btn-sm">Action</a>
                                                        
                                                        <form action="{{route('payment.status.change', $row->id)}}" method="POST">
                                                            @csrf
                                                            <div class="modal fade" id="myModal{{$row->id}}">
                                                                <div class="modal-dialog">
                                                                    <div class="modal-content">
                                                                        <div class="modal-header">
                                                                            <h4 class="modal-title">Action for Payment</h4>
                                                                            <button type="button" class="close" data-dismiss="modal">&times;</button>
                                                                        </div>
                                                                        <div class="modal-body">
                                                                            <div class="form-group">
                                                                                <label for="status">Status <small class="text-info">Approved adds balance to user.</small></label>
                                                                                <select name="status" required class="form-control">
                                                                                    <option value="approved">Approved</option>
                                                                                    <option value="rejected">Rejected</option>
                                                                                    <option value="pending">Pending</option>
                                                                                </select>
                                                                            </div>
                                                                        </div>
                                                                        <div class="modal-footer">
                                                                            <button type="submit" class="btn btn-primary">Submit</button>
                                                                            <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </form>
                                                    @else
                                                        <span class="text-muted small">Processed</span>
                                                    @endif

                                                    {{-- Login as User Button --}}
                                                    <a href="{{route('admin.customer.login', $row->id)}}" 
                                                       target="_blank" 
                                                       class="btn btn-info btn-sm ml-1" 
                                                       data-toggle="tooltip" 
                                                       title='Login Into User Account'>
                                                        <i class="bx bx-user"></i>
                                                    </a>
                                                </div>
                                            </td>
                                        </tr>
                                    @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection
