@extends('admin.partials.master')
@section('admin_content')
    <section id="dashboard-ecommerce">
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-header pb-0">
                        <h4 class="card-title">
                            <div class="d-flex justify-content-between">
                                <div>Package Details</div>
                                <div>
                                    <a href="{{route('admin.package.index')}}" class="btn btn-primary btn-sm"> 
                                        <i class="bx bx-list-ul"></i> Package List 
                                    </a> 
                                </div>
                            </div>
                        </h4>
                    </div>
                    <div class="card-content">
                        <div class="card-body card-dashboard">
                            <div class="table-responsive">
                                <table class="table table-bordered">
                                    <tr>
                                        <td style="font-weight: bold; width: 30%;">Package Name</td>
                                        <td>{{$data->name}}</td>
                                    </tr>

                                    <tr>
                                        <td style="font-weight: bold;">Title</td>
                                        <td>{{$data->title}}</td>
                                    </tr>

                                    <tr>
                                        <td style="font-weight: bold;">Photo</td>
                                        <td>
                                            <img src="{{asset($data->photo)}}" width="100" class="img-thumbnail">
                                        </td>
                                    </tr>

                                    <tr>
                                        <td style="font-weight: bold;">Price</td>
                                        <td class="text-primary" style="font-weight: bold;">{{price($data->price)}}</td>
                                    </tr>

                                    <tr>
                                        <td style="font-weight: bold;">Validity</td>
                                        <td>{{$data->validity}} Days</td>
                                    </tr>

                                    <tr>
                                        <td style="font-weight: bold;">Daily Income / Commission</td>
                                        <td>{{price($data->commission_with_avg_amount)}}</td>
                                    </tr>

                                    <tr>
                                        <td style="font-weight: bold; color: #ff0000;">Purchase Limit</td>
                                        <td style="font-weight: bold;">
                                            @if($data->purchase_limit == 0)
                                                <span class="badge badge-light-success">Unlimited</span>
                                            @else
                                                <span class="badge badge-light-danger">{{$data->purchase_limit}} Times Per User</span>
                                            @endif
                                        </td>
                                    </tr>

                                    <tr>
                                        <td style="font-weight: bold;">Level 1 Commission</td>
                                        <td>{{price($data->first_ref)}}</td>
                                    </tr>

                                    <tr>
                                        <td style="font-weight: bold;">Level 2 Commission</td>
                                        <td>{{price($data->second_ref)}}</td>
                                    </tr>

                                    <tr>
                                        <td style="font-weight: bold;">Level 3 Commission</td>
                                        <td>{{price($data->third_ref)}}</td>
                                    </tr>

                                    <tr>
                                        <td style="font-weight: bold;">Status</td>
                                        <td>
                                            @if($data->status == 'active')
                                                <span class="badge badge-success">Active</span>
                                            @else
                                                <span class="badge badge-danger">Inactive</span>
                                            @endif
                                        </td>
                                    </tr>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection
