@extends('admin.partials.master')
@section('admin_content')
<section id="dashboard-ecommerce">
    <div class="row">
        <div class="col-12">
            <form action="{{ route('admin.package.insert') }}" method="POST" enctype="multipart/form-data">
                @csrf
                <input type="hidden" name="id" value="{{ $data ? $data->id : '' }}">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title d-flex justify-content-between">
                            <div>{{ $data ? 'Update' : 'Create New' }} Package</div>
                            <div>
                                <a href="{{ route('admin.package.index') }}" class="btn btn-primary btn-sm"> 
                                    <i class="bx bx-left-arrow"></i> Package List
                                </a>
                            </div>
                        </h4>
                    </div>

                    <div class="card-content">
                        <div class="card-body">
                            <div class="row">

                                <div class="col-sm-6">
                                    <label for="name">Package Name</label>
                                    <input type="text" class="form-control" name="name" id="name"
                                           placeholder="Name" value="{{ $data ? $data->name : '' }}" required>
                                </div>

                                <div class="col-sm-6">
                                    <label for="title">Package Title</label>
                                    <input type="text" class="form-control" name="title" id="title"
                                           placeholder="Title" value="{{ $data ? $data->title : '' }}">
                                </div>

                                <div class="col-sm-6 mt-2">
                                    <label for="category">Package Category</label>
                                    <select name="category" id="category" class="form-control" required>
                                        <option value="">-- Select Category --</option>
                                        <option value="P Series" {{ $data && $data->category=='P Series' ? 'selected' : '' }}>P Series</option>
                                        <option value="B Series" {{ $data && $data->category=='B Series' ? 'selected' : '' }}>B Series</option>
                                    </select>
                                </div>

                                <div class="col-sm-6 mt-2">
                                    <label for="income_mode">Income Mode</label>
                                    <select name="income_mode" id="income_mode" class="form-control" required>
                                        <option value="">-- Select Income Mode --</option>
                                        <option value="daily" {{ isset($data) && $data->income_mode == 'daily' ? 'selected' : '' }}>Daily</option>
                                        <option value="maturity" {{ isset($data) && $data->income_mode == 'maturity' ? 'selected' : '' }}>At Maturity</option>
                                    </select>
                                </div>

                                <div class="col-sm-6 mt-2">
                                    <label for="progress">Progress (%)</label>
                                    <input type="number" class="form-control" name="progress" id="progress" step="0.1" min="0" max="100"
                                           placeholder="e.g. 6.4" value="{{ $data ? $data->progress : '' }}">
                                </div>

                                <div class="col-sm-12 mt-2">
                                    <div class="row">
                                        <div class="col-12 col-sm-6">
                                            <fieldset class="form-group">
                                                <label for="photo">Upload Photo <small>(Suggestion: 200x200px)</small></label>
                                                <input type="file" name="photo" class="form-control" id="photo" 
                                                       @if(!$data) required @endif onchange="showPreview(event)">
                                            </fieldset>
                                        </div>
                                        <div class="col-12 col-sm-6">
                                            <div class="image_preview">
                                                <img src="{{ $data ? asset(view_image($data->photo)) : asset(not_found_img()) }}"
                                                     id="file-ip-1-preview" class="rounded" alt="Preview Image"
                                                     style="width:100px; height:100px;">
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-sm-6 mt-2">
                                    <label for="price">Price</label>
                                    <input type="number" class="form-control" name="price" id="price"
                                           placeholder="Price" value="{{ $data ? $data->price : '' }}" required>
                                </div>

                                <div class="col-sm-6 mt-2">
                                    <label for="validity">Validity Days</label>
                                    <input type="number" class="form-control" name="validity" id="validity"
                                           placeholder="Validity days" value="{{ $data ? $data->validity : '' }}" required>
                                </div>

                                <div class="col-sm-6 mt-2">
                                    <label for="commission_with_avg_amount">Daily Commission Amount</label>
                                    <input type="number" class="form-control" name="commission_with_avg_amount"
                                           id="commission_with_avg_amount" placeholder="Commission amount" 
                                           value="{{ $data ? $data->commission_with_avg_amount : '' }}" required>
                                </div>

                                <div class="col-sm-6 mt-2">
                                    <label for="referral_bonus" style="color: #008400; font-weight: bold;">Invitation Bonus</label>
                                    <input type="number" class="form-control" name="referral_bonus"
                                           id="referral_bonus" placeholder="Invite bonus" 
                                           value="{{ $data ? $data->referral_bonus : '' }}" style="border: 1px solid #008400;">
                                    <small class="text-info">Invite bonus.</small>
                                </div>

                                <div class="col-sm-6 mt-2">
                                    <label for="purchase_limit" style="color: #ff0000; font-weight: bold;">Purchase Limit</label>
                                    <input type="number" class="form-control" name="purchase_limit"
                                           id="purchase_limit" placeholder="e.g. 2" 
                                           value="{{ $data ? $data->purchase_limit : '0' }}" style="border: 1px solid #ff0000;" min="0">
                                    <small class="text-danger">Max times a user can buy this (0 = Unlimited).</small>
                                </div>

                                <div class="col-sm-6 mt-2">
                                    <label for="status">Package Status</label>
                                    <select name="status" id="status" class="form-control">
                                        <option value="active" {{ $data && $data->status=='active' ? 'selected' : '' }}>Active</option>
                                        <option value="inactive" {{ $data && $data->status=='inactive' ? 'selected' : '' }}>In-Active</option>
                                    </select>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>

                <div class="card mt-2">
                    <div class="card-header d-flex justify-content-between">
                        <div>Submit Your Package Information</div>
                        <button type="submit" class="btn btn-success">
                            <i class="bx bx-plus"></i> {{ $data ? 'Update' : 'Submit' }}
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</section>

<script>
    function showPreview(event){
        if(event.target.files.length > 0){
            let src = URL.createObjectURL(event.target.files[0]);
            document.getElementById("file-ip-1-preview").src = src;
        }
    }
</script>
@endsection
