@extends('admin.partials.master')
@section('admin_content')
    <section id="dashboard-ecommerce">
        <div class="row">
            <div class="col-12">
                <form action="{{route('admin.bonus.insert')}}" method="POST" enctype="multipart/form-data">@csrf
                    <input type="hidden" name="id" value="{{$data ? $data->id : ''}}">
                    <div class="card">
                        <div class="card-header">
                            <h4 class="card-title">
                                <div class="d-flex justify-content-between">
                                    <div>{{$data ? 'Update' : 'Create New'}} Bonus</div>
                                    <div>
                                        <a href="{{route('admin.bonus.index')}}" class="btn btn-primary btn-sm"> <i
                                                class="bx bx-left-arrow"></i> Bonus List</a>
                                    </div>
                                </div>
                            </h4>
                        </div>
                        <div class="card-content">
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-sm-6">
                                        <label for="bonus_name">Bonus Name</label>
                                        <input type="text" class="form-control is-valid"
                                               name="bonus_name" id="bonus_name"
                                               placeholder="Bonus name" value="{{$data ? $data->bonus_name : old('bonus_name')}}" required>
                                        <div class="valid-feedback">
                                            <i class="bx bx-radio-circle"></i>
                                            Note: This field is required
                                        </div>
                                    </div>
                                    <div class="col-sm-6">
                                        <label for="set_service_counter">Usage Limit (Set Service Counter)</label>
                                        <input type="number" class="form-control is-valid"
                                               name="set_service_counter" id="set_service_counter"
                                               placeholder="Ex: 1 for one-time use" value="{{$data ? $data->set_service_counter : old('set_service_counter')}}" required>
                                        <div class="valid-feedback">
                                            <i class="bx bx-radio-circle"></i>
                                            Note: This field is required
                                        </div>
                                    </div>

                                    <div class="col-sm-6 mt-1">
                                        <label for="type">Bonus Reward Type</label>
                                        <select name="type" id="type" class="form-control is-valid" required>
                                            <option value="fix" {{ (isset($data) && $data->type == 'fix') ? 'selected' : '' }}>Fixed Amount</option>
                                            <option value="random" {{ (isset($data) && $data->type == 'random') ? 'selected' : '' }}>Random (Range 1-4)</option>
                                        </select>
                                        <div class="valid-feedback">
                                            <i class="bx bx-radio-circle"></i>
                                            Select "Random" for mystery reward.
                                        </div>
                                    </div>

                                    <div class="col-sm-6 mt-1">
                                        <label for="amount">Amount / Max Value</label>
                                        <input type="number" class="form-control is-valid"
                                               name="amount" id="amount"
                                               placeholder="Set Amount" value="{{$data ? $data->amount : old('amount')}}" required>
                                        <div class="valid-feedback">
                                            <i class="bx bx-radio-circle"></i>
                                            Note: This field is required
                                        </div>
                                    </div>

                                    <div class="col-sm-6 mt-1">
                                        <label for="price">Bonus Code <small>Ex: GIFT-100 </small> </label>
                                        <input type="text" class="form-control is-valid"
                                               name="code" id="price"
                                               placeholder="Ex: GIFT-100" value="{{$data ? $data->code : old('code')}}" required>
                                        <div class="valid-feedback">
                                            <i class="bx bx-radio-circle"></i>
                                            Note: This field is required
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="card">
                        <div class="card-header">
                            <h6 class="card-title">
                                <div class="d-flex justify-content-between">
                                    <div style="margin-top: .7rem !important">
                                        Submit Your Bonus Information
                                    </div>
                                    <div>
                                        <div class="form-group mb-0">
                                            <button type="submit" class="btn btn-success"><i
                                                    class="bx bx-plus"></i> {{$data ? 'Update' : 'Submit'}} Bonus </button>
                                        </div>
                                    </div>
                                </div>
                            </h6>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </section>

    <script>
        function showPreview(event){
            if(event.target.files.length > 0){
                var src = URL.createObjectURL(event.target.files[0]);
                var preview = document.getElementById("file-ip-1-preview");
                preview.src = src;
                preview.style.display = "block";
            }
        }
    </script>
@endsection
