@extends('admin.partials.master')
@section('admin_content')
    <section id="dashboard-ecommerce">
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-header pb-0">
                        <h4 class="card-title">
                            <div class="d-flex justify-content-between">
                                <div>Bonus Management Lists</div>
                                <div><a href="{{route('admin.bonus.create')}}" class="btn btn-primary btn-sm"> <i class="bx bx-plus"></i> Add New Item </a> </div>
                            </div>
                        </h4>
                    </div>
                    <div class="card-content">
                        <div class="card-body card-dashboard">
                            <div class="table-responsive">
                                <table class="table table-striped dataex-html5-selectors">
                                    <thead>
                                    <tr>
                                        <th>S.N</th>
                                        <th>Bonus Name</th>
                                        <th>Type</th> <th>Usage (Used/Limit)</th>
                                        <th>Distributed Amount</th> <th>Code</th>
                                        <th>Base Amount</th>
                                        <th>Status</th>
                                        <th>Actions</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @foreach($datas as $key => $row)
                                        <tr>
                                            <td>{{$key + 1}}</td>
                                            <td>{{$row->bonus_name}}</td>
                                            <td>
                                                <span class="badge {{ $row->type == 'random' ? 'bg-warning' : 'bg-info' }}" style="color: white; padding: 5px;">
                                                    {{ strtoupper($row->type ?? 'FIX') }}
                                                </span>
                                            </td>
                                            <td>
                                                <b class="text-primary">{{$row->counter}}</b> / <b>{{$row->set_service_counter}}</b>
                                            </td>
                                            <td>
                                                <b class="text-success">{{ price(\App\Models\BonusLedger::where('bonus_id', $row->id)->sum('amount')) }}</b>
                                            </td>
                                            <td><span class="badge bg-light-secondary">{{$row->code}}</span></td>
                                            <td>{{price($row->amount)}}</td>
                                            <td>
                                                @if($row->counter >= $row->set_service_counter)
                                                    <span class="badge bg-danger">Full / Deactivated</span>
                                                @else
                                                    <span class="badge {{ $row->status == 'active' ? 'bg-success' : 'bg-secondary' }}">
                                                        {{ucfirst($row->status)}}
                                                    </span>
                                                @endif
                                            </td>
                                            <td>
                                                <a href="{{route('admin.bonus.status', $row->id)}}"
                                                   class="btn @if($row->status == 'active') btn-success @else btn-danger @endif"
                                                   style="padding: 3px 7px;font-size: 20px"
                                                   data-toggle="tooltip"
                                                   title='Bonus status change'>
                                                    <i class="bx @if($row->status == 'active') bx-up-arrow @else bx-down-arrow @endif"></i></a>

                                                <a href="{{route('admin.bonus.create', $row->id)}}"
                                                   class="btn btn-warning" style="padding: 3px 7px;font-size: 20px" data-toggle="tooltip" title='Edit'>
                                                    <i class="bx bx-pencil"></i></a>

                                                <form method="POST" action="{{route('admin.bonus.delete', $row->id)}}"
                                                      class="d-inline">@csrf
                                                    {{method_field('DELETE')}}
                                                    <button type="submit"
                                                            style="padding: 3px 7px;"
                                                            class="btn btn-icon btn-danger delete_confirm{{$row->id}}"
                                                            data-toggle="tooltip" title='Delete'>
                                                        <i class="bx bx-trash"></i>
                                                    </button>
                                                    @include('admin.partials.delete-confirmation')
                                                </form>
                                            </td>
                                        </tr>
                                    @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection
