<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class UserLedger extends Model
{
    use HasFactory;

    // Allow mass assignment for these fields
    protected $fillable = [
        'user_id',
        'reason',
        'perticulation',
        'amount',
        'debit',
        'type',
        'status',
        'date',
    ];

    // Optionally, define any relationships
    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
