<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class TaskRequest extends Model
{
    protected $fillable = [
        'user_id',
        'task_id',
        'progress',
        'team_invest',
        'team_size',
        'bonus',
        'status',
        'last_paid_month',
    ];

    protected $dates = ['last_paid_month'];

    public function task()
    {
        return $this->belongsTo(Task::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
