<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Models\User;
use App\Models\TaskRequest;

class Task extends Model
{
    protected $fillable = [
        'level',
        'required_invites',
        'required_purchase',
        'bonus',
        'extra_profit',
        'vip_level_name',
    ];

    public function taskRequests()
    {
        return $this->hasMany(TaskRequest::class);
    }

    public function completedCount(User $user)
    {
        return $user->qualifiedReferrals($this->required_purchase)->count();
    }

    public function isEligible(User $user)
    {
        return $this->completedCount($user) >= $this->required_invites;
    }
}
