<?php
namespace App\Http\Services\Deposit\Bank;

use App\Http\Services\Deposit\Bank\ManualBankDepositServices;
use App\Models\Setting;
/**
 * Laravel/Symfony Developer
 * Name: bukar mai 
 * Telegram: @Mamber001
 * Hire me via Telegram: @Mamber001
 */
class ProcessBankDepositServices
{
    private $manual;
    private $gcashpay; 
    private $heypay;

    public function __construct(
        ManualBankDepositServices $manual,
        GcashPayBankDepositServices   $gcashpay, 
        HeyPayBankDepositServices  $heypay
    )
    {
        $this->manual = $manual;
        $this->gcashpay = $gcashpay; 
        $this->heypay= $heypay;
    } 

    /**
     * Deposit Payment
     * 
     * @param string reference
     * @param string currency
     * @param string amount
     * @param string method
     */
    public function deposit(
        string $reference,
        string $currency,
        string $amount,
        string $method
    )
    {
        try {

            // Hold User
            $setting = Setting::first();

            if($setting->auto_deposit) {

            // Verify transfer Type
            if(!in_array($method, ['gcashpay','heypay'])) throw new \Exception("Deposit not available at the moment");
                
                // gcashpay
            if(in_array($method, ['gcashpay'])) {
                $payment = $this->gcashpay->deposit($reference, $currency, $amount, $method);
            } 
            // rtpay
            if(in_array($method, ['heypay'])) {
                $payment = $this->heypay->deposit($reference, $currency, $amount, $method);
            }
                
            }else {
                // Manual
                $payment = $this->manual->deposit($reference, $currency, $amount, $method);
            }

            // Exception
            if($payment instanceof \Exception) throw new \Exception($payment->getMessage());

            // Response
            return $payment;

        } catch (\Exception $th) {
            //throw $th;
            return $th;
        }
    }
}
