<?php

namespace App\Http\Controllers\User;

use App\Http\Controllers\Controller;
use App\Models\Deposit;
use App\Models\Purchase;
use App\Models\User;
use App\Models\UserLedger;
use App\Models\Withdrawal;
use Illuminate\Support\Facades\Auth;

class TeamController extends Controller
{
    private function getTeamData($levelType = 'all')
    {
        $user = Auth::user();

        // 1. Levels logic
        $first_level_users = User::where('ref_by', $user->ref_id)->get();
        $first_ids = $first_level_users->pluck('id');

        $second_level_users = User::whereIn('ref_by', $first_level_users->pluck('ref_id'))->get();
        $second_ids = $second_level_users->pluck('id');

        $third_level_users = User::whereIn('ref_by', $second_level_users->pluck('ref_id'))->get();
        $third_ids = $third_level_users->pluck('id');

        // 2. Valid Team Logic (Unique Users who have at least one purchase)
        $valid_purchase1 = Purchase::whereIn('user_id', $first_ids)->distinct('user_id')->count();
        $valid_purchase2 = Purchase::whereIn('user_id', $second_ids)->distinct('user_id')->count();
        $valid_purchase3 = Purchase::whereIn('user_id', $third_ids)->distinct('user_id')->count();

        // 3. Purchase count (Total investments)
        $purchase1 = Purchase::whereIn('user_id', $first_ids)->count();
        $purchase2 = Purchase::whereIn('user_id', $second_ids)->count();
        $purchase3 = Purchase::whereIn('user_id', $third_ids)->count();

        // 4. Summaries
        $all_ids = array_merge($first_ids->toArray(), $second_ids->toArray(), $third_ids->toArray());
        $team_size = count($all_ids);

        $totalDeposit = Deposit::whereIn('user_id', $all_ids)->where('status', 'approved')->sum('amount');
        $totalWithdraw = Withdrawal::whereIn('user_id', $all_ids)->where('status', 'approved')->sum('amount');

        $totalDeposit1 = Deposit::whereIn('user_id', $first_ids)->where('status', 'approved')->sum('amount');
        $totalDeposit2 = Deposit::whereIn('user_id', $second_ids)->where('status', 'approved')->sum('amount');
        $totalDeposit3 = Deposit::whereIn('user_id', $third_ids)->where('status', 'approved')->sum('amount');

        $totalWithdraw1 = Withdrawal::whereIn('user_id', $first_ids)->where('status', 'approved')->sum('amount');
        $totalWithdraw2 = Withdrawal::whereIn('user_id', $second_ids)->where('status', 'approved')->sum('amount');
        $totalWithdraw3 = Withdrawal::whereIn('user_id', $third_ids)->where('status', 'approved')->sum('amount');

        // Commissions
        $commission1 = UserLedger::where('user_id', $user->id)->where('reason', 'commission')->whereIn('get_balance_from_user_id', $first_ids)->sum('amount');
        $commission2 = UserLedger::where('user_id', $user->id)->where('reason', 'commission')->whereIn('get_balance_from_user_id', $second_ids)->sum('amount');
        $commission3 = UserLedger::where('user_id', $user->id)->where('reason', 'commission')->whereIn('get_balance_from_user_id', $third_ids)->sum('amount');
        $totalCommission = $commission1 + $commission2 + $commission3;

        return compact(
            'first_level_users', 'second_level_users', 'third_level_users',
            'team_size', 'first_ids', 'second_ids', 'third_ids',
            'totalDeposit', 'totalWithdraw',
            'totalDeposit1', 'totalDeposit2', 'totalDeposit3',
            'totalWithdraw1', 'totalWithdraw2', 'totalWithdraw3',
            'purchase1', 'purchase2', 'purchase3',
            'valid_purchase1', 'valid_purchase2', 'valid_purchase3', // <--- Inko Blade me use karein
            'totalCommission', 'commission1', 'commission2', 'commission3'
        );
    }

    public function team() { return view('app.main.team.index', $this->getTeamData()); }
    public function teama() { return view('app.main.team.teama', $this->getTeamData()); }
    public function teamb() { return view('app.main.team.teamb', $this->getTeamData()); }
    public function teamc() { return view('app.main.team.teamc', $this->getTeamData()); }

    public function team_result()
    {
        $user = auth()->user();
        $first_ids = User::where('ref_by', $user->ref_id)->pluck('id');
        $second_ids = User::whereIn('ref_by', User::whereIn('id', $first_ids)->pluck('ref_id'))->pluck('id');
        $third_ids = User::whereIn('ref_by', User::whereIn('id', $second_ids)->pluck('ref_id'))->pluck('id');
        $users = User::whereIn('id', array_merge($first_ids->toArray(), $second_ids->toArray(), $third_ids->toArray()))->get();
        return view('app.main.team.list', compact('users'));
    }
}
