<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Models\Setting;
use App\Models\PaymentMethod; // Fixed: Imported the model
use Illuminate\Http\Request;
use Illuminate\Support\Str;

class SettingController extends Controller
{
    public $route = 'admin.setting';

    public function index()
    {
        // Fetch the site settings
        $data = Setting::find(1);
        
        /**
         * FIX: Your blade file at line 269 needs singular "$paymentMethod"
         * We fetch all methods to ensure the variable is defined.
         */
        $paymentMethod = PaymentMethod::get(); 

        // Pass variables to the view
        return view('admin.pages.setting.index', compact('data', 'paymentMethod'));
    }

    public function insert_or_update(Request $request)
    {
        $model = Setting::findOrFail(1);
        
        // General Settings
        $model->minimum_withdraw = $request->minimum_withdraw;
        $model->maximum_withdraw = $request->maximum_withdraw;
        $model->withdraw_charge = $request->withdraw_charge;
        $model->minimum_recharge = $request->minimum_recharge;

        // Logo Upload
        $path = uploadImage(false, $request, 'logo', 'upload/logo/', 200, 200, $model->logo);
        $model->logo = $path ?? $model->logo;

        // Referral Commissions
        $model->first_ref = $request->first_ref;
        $model->second_ref = $request->second_ref;
        $model->third_ref = $request->third_ref;

        // Site Info
        $model->currency = $request->currency;
        $model->notice = $request->notice;

        // Social & Automation
        $model->telegram = $request->telegram;
        $model->telegram_group = $request->telegram_group;
        $model->telegram_channel = $request->telegram_channel;
        $model->checkin = $request->checkin;
        $model->auto_deposit = $request->auto_deposit;
        $model->auto_transfer = $request->auto_transfer;
        $model->auto_transfer_default = $request->auto_transfer_default;

        // Open/Close status
        $model->open_deposit = $request->open_deposit;
        $model->open_transfer = $request->open_transfer;

        $model->update();
        
        return redirect()->route($this->route.'.index')->with('success', 'Settings Updated Successfully.');
    }
}
