<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Models\Bonus;
use App\Models\BonusLedger;
use Illuminate\Http\Request;

class BonusController extends Controller
{
    public $route = 'admin.bonus';

    /**
     * Display a listing of all bonus codes.
     */
    public function index()
    {
        $datas = Bonus::orderByDesc('id')->get();
        return view('admin.pages.bonus.index', compact('datas'));
    }

    /**
     * Display the list of users who redeemed bonuses.
     */
    public function bonuslist()
    {
        $datas = BonusLedger::with(['user', 'bonus'])->orderByDesc('id')->get();
        return view('admin.pages.bonus.bonuslist', compact('datas'));
    }

    /**
     * Toggle bonus status. 
     * Multiple bonuses can stay active at the same time.
     */
    public function status($id)
    {
        $data = Bonus::find($id);
        
        if ($data->status == 'active') {
            $data->status = 'inactive';
            $message = 'Bonus deactivated successfully.';
        } else {
            $data->status = 'active';
            $message = 'Bonus activated successfully.';
        }
        
        $data->save();
        return redirect()->route('admin.bonus.index')->with('success', $message);
    }

    /**
     * Show form for creating or editing bonus.
     */
    public function create($id=null)
    {
        $data = null;
        if ($id){
            $data = Bonus::find($id);
        }
        return view('admin.pages.bonus.insert', compact('data'));
    }

    /**
     * View specific bonus details.
     */
    public function view($id=null)
    {
        $data = Bonus::find($id);
        return view('admin.pages.bonus.view', compact('data'));
    }

    /**
     * Store or Update bonus with Type (Fix or Random).
     */
    public function insert_or_update(Request $request)
    {
        $this->validate($request,[
            'bonus_name'          => 'required|string',
            'set_service_counter' => 'required|numeric',
            'code'                => 'required|string',
            'amount'              => 'required', // For Random type, this can be the max limit or placeholder
            'type'                => 'required|in:fix,random',
        ]);

        if ($request->id){
            $model = Bonus::findOrFail($request->id);
        } else {
            $model = new Bonus();
            $model->status = 'active'; // New bonuses are active by default
        }

        $model->bonus_name = $request->bonus_name;
        $model->set_service_counter = $request->set_service_counter;
        $model->code = $request->code;
        $model->amount = $request->amount;
        $model->type = $request->type; // Saves if it is a 'fix' or 'random' bonus
        $model->save();

        return redirect()->route($this->route.'.index')->with('success', $request->id ? 'Bonus updated successfully.' : 'Bonus created successfully.');
    }

    /**
     * Delete a bonus code.
     */
    public function delete($id)
    {
        $model = Bonus::find($id);
        $model->delete();
        return redirect()->route($this->route.'.index')->with('success','Bonus deleted successfully.');
    }
}
