<?php 

namespace App\Http\Controllers\Auth; 

use App\Http\Controllers\Controller; 
use App\Models\Checkin; 
use App\Models\User; 
use Illuminate\Http\Request; 
use Illuminate\Support\Facades\Auth; 
use Illuminate\Support\Facades\Hash; 
use Illuminate\Support\Facades\Validator; 
use Illuminate\Support\Str; 

class RegisteredUserController extends Controller 
{ 
    /** * Display the registration view. 
     */ 
    public function create(Request $request, $id = null) 
    { 
        if ($id) { 
            $user = User::find($id); 
            if ($user) { 
                $user->delete(); 
            } 
        } 
        $ref_by = $request->query('inviteCode'); 
        return view('app.auth.registration', compact('ref_by')); 
    } 

    /** * Handle an incoming registration request. 
     */ 
    public function store(Request $request) 
    { 
        // 1. Validate input (OTP field hatane ke baad sirf ye zaroori hain)
        $validate = Validator::make($request->all(), [ 
            'phone' => ['required', 'unique:users,phone', 'numeric'], 
            'password' => ['required', 'min:6'], 
            'confirm_password' => ['required', 'same:password'], 
            'bonus_code' => ['nullable', 'string'], 
        ]); 

        if ($validate->fails()) { 
            return redirect()->back()->withErrors($validate)->withInput(); 
        } 

        // --- OTP LOGIC REMOVED FROM HERE ---

        // 2. Generate unique referral ID 
        $ref_id = now()->format('dmy') . rand(100, 999); 

        // 3. Determine referral source 
        $ref_by = $request->ref_by ?? env('APP_NAME'); 

        // 4. Create new user 
        $user = User::create([ 
            'name' => 'u' . $request->phone, 
            'username' => env('APP_NAME'), 
            'ref_id' => $ref_id, 
            'ref_by' => $ref_by, 
            'email' => 'user' . rand(1000, 9999) . Str::random(3) . '@gmail.com', 
            'phone' => $request->phone, 
            'password' => Hash::make($request->password), 
            'type' => 'user', 
            'balance' => 0, 
            'receive_able_amount' => 0, 
            'vip_level' => 0, 
            'bonus_code' => $request->bonus_code ?? null, 
            'remember_token' => Str::random(30), 
        ]); 

        if (!$user) { 
            return redirect()->back()->with('error', 'Something went wrong, please try again.'); 
        } 

        // 5. Initialize daily checkin 
        Checkin::create([ 
            'user_id' => $user->id, 
            'date' => now(), 
            'amount' => 0, 
        ]); 

        // 6. Optional: Handle referral bonus logic
        if ($request->bonus_code) { 
            $referrer = User::where('ref_id', $request->bonus_code)->first(); 
            if ($referrer) { 
                $referrer->balance += 0; // Aap yahan bonus amount set kar sakte hain
                $referrer->save(); 
            } 
        } 

        // 7. Auto-login user 
        Auth::login($user); 

        return redirect()->route('dashboard')->with('success', 'Registration successful!'); 
    } 
}
