<?php

include_once(__DIR__ . '/function.php');

$oid = $_REQUEST['oid'] ?? '';
$name = $_REQUEST['name'] ?? '';
$number = $_REQUEST['number'] ?? '';
$converted_amount = $_REQUEST['converted_amount'] ?? '';

if (empty($oid) || empty($name) || empty($number) || empty($converted_amount)) {
    die(json_encode(['status' => 'error', 'message' => 'Missing required fields']));
}

$notifyUrl = 'https://ml.makenitro.com/services/wcallback.php'; 
$pageUrl   = 'https://ml.makenitro.com/';

$data['bankCode'] = 'GCASH'; // Bank code

if ($data['bankCode'] == "IMPS") {
    $data['province'] = 'test';
}

$data['accName'] = $name; 
$data['accNo'] = $number; 
$data['busiCode'] = '212001';        // Payment code
$data['currency'] = 'PHP';    
$data['email'] = 'test@mail.com';  
$data['merNo'] = $mch_id; 
$data['merOrderNo'] = $oid; 
$data['notifyUrl'] = $notifyUrl; 
$data['orderAmount'] = $converted_amount; 
$data['phone'] = $number;    
$data['timestamp'] = msectime(); 

$data["sign"] = encrypt($data); 

$data_json = json_encode($data, JSON_UNESCAPED_UNICODE);

$url = 'https://taslk.gctpk.com/payout/singleOrder';
$ret = globalpay_http_post_res_json($url, $data_json); 
$ret_arr = json_decode($ret, true);  

echo $ret;

## ==============================
## 🧾 Logs
## ==============================
$logFile = __DIR__ . '/transfer_logs.txt';
$logData = "=====================================\n";
$logData .= "Date: " . date('Y-m-d H:i:s') . "\n";
$logData .= "OID: $oid\n";
$logData .= "Name: $name\n";
$logData .= "Number: $number\n";
$logData .= "Amount: $converted_amount\n";
$logData .= "Request Method: " . $_SERVER['REQUEST_METHOD'] . "\n";
$logData .= "Request: " . $data_json . "\n";
$logData .= "Response: " . $ret . "\n";
$logData .= "=====================================\n\n";

file_put_contents($logFile, $logData, FILE_APPEND);
?>
