<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Bank Maintenance</title>
  <style>
    @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap');

    body {
      margin: 0;
      padding: 0;
      font-family: 'Poppins', sans-serif;
      background: linear-gradient(145deg, #111827, #1e293b);
      color: #f1f5f9;
      display: flex;
      align-items: center;
      justify-content: center;
      height: 100vh;
      text-align: center;
    }

    .card {
      background: rgba(255, 255, 255, 0.05);
      border: 1px solid rgba(255, 255, 255, 0.1);
      border-radius: 20px;
      padding: 40px 30px;
      max-width: 400px;
      width: 90%;
      box-shadow: 0 10px 30px rgba(0, 0, 0, 0.4);
      backdrop-filter: blur(10px);
    }

    .icon {
      font-size: 60px;
      color: #38bdf8;
      margin-bottom: 15px;
      animation: spin 6s linear infinite;
    }

    @keyframes spin {
      0% { transform: rotate(0deg); }
      100% { transform: rotate(360deg); }
    }

    h1 {
      font-size: 1.8rem;
      margin-bottom: 10px;
      color: #38bdf8;
    }

    p {
      font-size: 1rem;
      color: #cbd5e1;
      margin: 0;
      line-height: 1.6;
    }

    footer {
      margin-top: 20px;
      font-size: 0.85rem;
      color: #64748b;
    }

    @media (max-width: 600px) {
      h1 { font-size: 1.5rem; }
      p { font-size: 0.95rem; }
      .icon { font-size: 50px; }
    }
  </style>
</head>
<body>
  <div class="card">
    <div class="icon">⚙️</div>
    <h1>Bank is Under Maintenance</h1>
    <p>We’re currently performing some updates to improve your experience.<br>
    Please try again after a short while.</p>
    <footer>Thank you for your patience 🙏</footer>
  </div>
</body>
</html>
